/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.model;

import betterblockentities.gui.ConfigManager;
import betterblockentities.resource.model.models.BedModels;
import betterblockentities.resource.model.models.ChestModels;
import betterblockentities.resource.model.models.ShulkerModels;
import betterblockentities.resource.model.models.SignModels;
import betterblockentities.resource.model.util.TemplateLoader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelGenerator {
    protected static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    protected static final String NAMESPACE = "minecraft";
    protected static final TemplateLoader loader = new TemplateLoader();

    public Map<String, byte[]> generateAllModels() {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        if (ConfigManager.CONFIG.master_optimize) {
            if (ConfigManager.CONFIG.optimize_chests) {
                ChestModels.Model.generateLeftChests(entries);
                ChestModels.Model.generateRightChests(entries);
                ChestModels.Model.generateSingleChests(entries);
                ChestModels.BlockState.generateChestBlockstates(entries);
            }
            if (ConfigManager.CONFIG.optimize_beds) {
                BedModels.Model.generateBedsHead(entries);
                BedModels.Model.generateBedsFoot(entries);
                BedModels.BlockState.generateBedBlockstates(entries);
            }
            if (ConfigManager.CONFIG.optimize_shulkers) {
                ShulkerModels.Model.generateShulkerBase(entries);
                ShulkerModels.Model.generateShulkerLid(entries);
                ShulkerModels.BlockState.generateShulkerBlockstates(entries);
            }
            if (ConfigManager.CONFIG.optimize_signs) {
                SignModels.Model.generateSignModels(entries);
                SignModels.BlockState.generateSignBlockstates(entries);
            }
        }
        return entries;
    }

    protected static JsonObject makeModel(String texKey, String texture, List<TemplateLoader.ElementRecord> elements) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "block/block");
        JsonObject textures = new JsonObject();
        textures.addProperty(texKey, texture);
        model.add("textures", (JsonElement)textures);
        model.add("elements", GSON.toJsonTree(elements));
        return model;
    }

    protected static JsonObject makeModelWithParticle(String texKey, String texture, String particle, List<TemplateLoader.ElementRecord> elements) {
        JsonObject model = new JsonObject();
        model.addProperty("parent", "block/block");
        JsonObject textures = new JsonObject();
        textures.addProperty("particle", particle);
        textures.addProperty(texKey, texture);
        model.add("textures", (JsonElement)textures);
        model.add("elements", GSON.toJsonTree(elements));
        return model;
    }

    protected static JsonObject createVariant(String name, int x, int y) {
        JsonObject v = new JsonObject();
        v.addProperty("model", "minecraft:block/" + name);
        if (x != 0) {
            v.addProperty("x", (Number)x);
        }
        if (y != 0) {
            v.addProperty("y", (Number)y);
        }
        return v;
    }

    protected static JsonObject createVariantFloat(String name, float x, float y) {
        JsonObject v = new JsonObject();
        v.addProperty("model", "minecraft:block/" + name);
        if (x != 0.0f) {
            v.addProperty("x", (Number)Float.valueOf(x));
        }
        if (y != 0.0f) {
            v.addProperty("y", (Number)Float.valueOf(y));
        }
        return v;
    }
}

