/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.model.models;

import betterblockentities.resource.model.ModelGenerator;
import betterblockentities.resource.model.util.TemplateLoader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1767;

public class ShulkerModels
extends ModelGenerator {

    public static class BlockState {
        public static void generateShulkerBlockstates(Map<String, byte[]> map) {
            Map<String, int[]> facingRot = Map.of("up", new int[]{0, 180}, "down", new int[]{180, 180}, "north", new int[]{90, 0}, "south", new int[]{90, 180}, "west", new int[]{90, 270}, "east", new int[]{90, 90});
            for (class_1767 color : class_1767.values()) {
                String baseName = color.method_7792() + "_shulker_box";
                JsonArray multipart = new JsonArray();
                for (Map.Entry<String, int[]> entry : facingRot.entrySet()) {
                    String facing = entry.getKey();
                    int xRot = entry.getValue()[0];
                    int yRot = entry.getValue()[1];
                    multipart.add((JsonElement)BlockState.makeShulkerPart(baseName + "_base", facing, xRot, yRot));
                    multipart.add((JsonElement)BlockState.makeShulkerPart(baseName + "_lid", facing, xRot, yRot));
                }
                JsonObject root = new JsonObject();
                root.add("multipart", (JsonElement)multipart);
                map.put("assets/minecraft/blockstates/" + baseName + ".json", GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
            }
            String baseName = "shulker_box";
            JsonArray baseMultipart = new JsonArray();
            for (Map.Entry<String, int[]> entry : facingRot.entrySet()) {
                String facing = entry.getKey();
                int xRot = entry.getValue()[0];
                int yRot = entry.getValue()[1];
                baseMultipart.add((JsonElement)BlockState.makeShulkerPart(baseName + "_base", facing, xRot, yRot));
                baseMultipart.add((JsonElement)BlockState.makeShulkerPart(baseName + "_lid", facing, xRot, yRot));
            }
            JsonObject baseRoot = new JsonObject();
            baseRoot.add("multipart", (JsonElement)baseMultipart);
            map.put("assets/minecraft/blockstates/" + baseName + ".json", GSON.toJson((JsonElement)baseRoot).getBytes(StandardCharsets.UTF_8));
        }

        private static JsonObject makeShulkerPart(String model, String facing, int xRot, int yRot) {
            JsonObject when = new JsonObject();
            when.addProperty("facing", facing);
            JsonObject apply = new JsonObject();
            apply.addProperty("model", "minecraft:block/" + model);
            if (xRot != 0) {
                apply.addProperty("x", (Number)xRot);
            }
            if (yRot != 0) {
                apply.addProperty("y", (Number)yRot);
            }
            JsonObject part = new JsonObject();
            part.add("when", (JsonElement)when);
            part.add("apply", (JsonElement)apply);
            return part;
        }
    }

    public static class Model {
        private static String getParticleTexture(class_1767 color) {
            return "minecraft:block/" + color.method_7792() + "_shulker_box";
        }

        public static void generateShulkerBase(Map<String, byte[]> map) {
            JsonObject template = loader.loadTemplate("shulker_base_template.json");
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (class_1767 color : class_1767.values()) {
                String name = color.method_7792() + "_shulker_box_base";
                String texture = "minecraft:entity/shulker/shulker_" + color.method_7792();
                map.put("assets/minecraft/models/block/" + name + ".json", GSON.toJson((JsonElement)ShulkerModels.makeModelWithParticle("shulker", texture, Model.getParticleTexture(color), elements)).getBytes(StandardCharsets.UTF_8));
            }
            String baseName = "shulker_box_base";
            String baseTexture = "minecraft:entity/shulker/shulker";
            map.put("assets/minecraft/models/block/" + baseName + ".json", GSON.toJson((JsonElement)ShulkerModels.makeModelWithParticle("shulker", baseTexture, "minecraft:block/shulker_box", elements)).getBytes(StandardCharsets.UTF_8));
        }

        public static void generateShulkerLid(Map<String, byte[]> map) {
            JsonObject template = loader.loadTemplate("shulker_lid_template.json");
            if (template == null) {
                return;
            }
            List<TemplateLoader.ElementRecord> elements = loader.readTemplateElements(template);
            for (class_1767 color : class_1767.values()) {
                String name = color.method_7792() + "_shulker_box_lid";
                String texture = "minecraft:entity/shulker/shulker_" + color.method_7792();
                map.put("assets/minecraft/models/block/" + name + ".json", GSON.toJson((JsonElement)ShulkerModels.makeModelWithParticle("shulker", texture, Model.getParticleTexture(color), elements)).getBytes(StandardCharsets.UTF_8));
            }
            String baseName = "shulker_box_lid";
            String baseTexture = "minecraft:entity/shulker/shulker";
            map.put("assets/minecraft/models/block/" + baseName + ".json", GSON.toJson((JsonElement)ShulkerModels.makeModelWithParticle("shulker", baseTexture, "minecraft:block/shulker_box", elements)).getBytes(StandardCharsets.UTF_8));
        }
    }
}

