/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class Pack
implements class_3262 {
    private final String name;
    private final byte[] packData;
    private final Map<String, byte[]> entries = new HashMap<String, byte[]>();
    private final Map<class_3264, Set<String>> namespaces = new EnumMap<class_3264, Set<String>>(class_3264.class);

    public Pack(String name, byte[] packData) {
        this.name = name;
        this.packData = packData;
        this.buildCache();
    }

    private void buildCache() {
        try (ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(this.packData));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                byte[] data = zip.readAllBytes();
                this.entries.put(entry.getName(), data);
                for (class_3264 type : class_3264.values()) {
                    String dir = type.method_14413() + "/";
                    if (!entry.getName().startsWith(dir)) continue;
                    String rest = entry.getName().substring(dir.length());
                    String namespace = rest.split("/", 2)[0];
                    this.namespaces.computeIfAbsent(type, t -> new HashSet()).add(namespace);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... segments) {
        String path = String.join((CharSequence)"/", segments);
        byte[] data = this.entries.get(path);
        return data == null ? null : () -> new ByteArrayInputStream(data);
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        String path = type.method_14413() + "/" + id.method_12836() + "/" + id.method_12832();
        byte[] data = this.entries.get(path);
        return data == null ? null : () -> new ByteArrayInputStream(data);
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        String base = type.method_14413() + "/" + namespace + "/" + prefix;
        this.entries.forEach((path, data) -> {
            if (path.startsWith(base)) {
                String relative = path.substring(type.method_14413().length() + 1 + namespace.length() + 1);
                consumer.accept((Object)class_2960.method_60655((String)namespace, (String)relative), () -> new ByteArrayInputStream((byte[])data));
            }
        });
    }

    public Set<String> method_14406(class_3264 type) {
        return this.namespaces.getOrDefault(type, Collections.emptySet());
    }

    @Nullable
    public <T> T method_14407(class_7677<T> metadataSerializer) throws IOException {
        class_7367<InputStream> input = this.method_14410("pack.mcmeta");
        if (input == null) {
            return null;
        }
        try (InputStream stream = (InputStream)input.get();){
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
            if (!json.has(metadataSerializer.comp_3436())) {
                T t = null;
                return t;
            }
            JsonElement section = json.get(metadataSerializer.comp_3436());
            T t = metadataSerializer.comp_3437().parse((DynamicOps)JsonOps.INSTANCE, (Object)section).result().orElse(null);
            return t;
        }
    }

    public class_9224 method_56926() {
        return new class_9224(this.name, (class_2561)class_2561.method_43470((String)"BBE-generated"), class_5352.field_25348, Optional.empty());
    }

    public void close() {
    }
}

