/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.resource.pack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ResourcePackAssembler {
    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] assemble(Map<String, byte[]> allResources) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (ZipOutputStream zip = new ZipOutputStream(baos);){
                for (Map.Entry<String, byte[]> entry : allResources.entrySet()) {
                    zip.putNextEntry(new ZipEntry(entry.getKey()));
                    zip.write(entry.getValue());
                    zip.closeEntry();
                }
                zip.finish();
                object = baos.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to build in-memory resource pack", e);
        }
    }
}

