/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.util;

import betterblockentities.BetterBlockEntities;
import betterblockentities.chunk.ChunkUpdateDispatcher;
import betterblockentities.gui.ConfigManager;
import betterblockentities.util.BlockEntityExt;
import betterblockentities.util.BlockEntityTracker;
import betterblockentities.util.BlockVisibilityChecker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2336;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2508;
import net.minecraft.class_2551;
import net.minecraft.class_2586;
import net.minecraft.class_2618;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_310;
import net.minecraft.class_3709;
import net.minecraft.class_3721;
import net.minecraft.class_4604;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7717;
import net.minecraft.class_8168;
import net.minecraft.class_8172;

public class BlockEntityManager {
    public static Set<Class<? extends class_2586>> SUPPORTED_TYPES = Collections.emptySet();
    public static final Set<Class<? extends class_2248>> SUPPORTED_BLOCKS = Set.of(class_2281.class, class_2336.class, class_2480.class, class_3709.class, class_8168.class, class_2244.class, class_2508.class, class_7713.class, class_2551.class, class_7715.class);
    public static boolean chestAnims;
    public static boolean shulkerAnims;
    public static boolean bellAnims;
    public static boolean potAnims;
    public static boolean signText;
    public static boolean masterOptimize;
    public static int smoothness;

    public static boolean isSupportedBlock(class_2248 block) {
        return block != null && SUPPORTED_BLOCKS.contains(block.getClass());
    }

    public static boolean isSupportedEntity(class_2586 blockEntity) {
        return blockEntity != null && SUPPORTED_TYPES.contains(blockEntity.getClass());
    }

    public static boolean isSignEntity(class_2586 blockEntity) {
        return blockEntity != null && class_2625.class == blockEntity.getClass() || class_7717.class == blockEntity.getClass();
    }

    private static boolean isAnimating(class_2586 blockEntity) {
        if (chestAnims && blockEntity instanceof class_2618) {
            class_2618 lid = (class_2618)blockEntity;
            return lid.method_11274(0.5f) > 0.0f;
        }
        if (shulkerAnims && blockEntity instanceof class_2627) {
            class_2627 shulker = (class_2627)blockEntity;
            return shulker.method_11312(0.5f) > 0.0f;
        }
        if (bellAnims && blockEntity instanceof class_3721) {
            class_3721 bell = (class_3721)blockEntity;
            return bell.field_17096;
        }
        if (potAnims && blockEntity instanceof class_8172) {
            class_8172 pot = (class_8172)blockEntity;
            if (pot.field_46662 != null) {
                long now = blockEntity.method_10997().method_8510();
                return now - pot.field_46661 < (long)pot.field_46662.field_46666;
            }
        }
        if (signText && blockEntity instanceof class_2625) {
            boolean shouldRenderText;
            double maxSignTextDistance = ConfigManager.CONFIG.sign_text_render_distance;
            class_1297 entity = class_310.method_1551().method_1560();
            boolean bl = shouldRenderText = entity.method_5707(class_243.method_24953((class_2382)blockEntity.method_11016())) < maxSignTextDistance * maxSignTextDistance;
            if (shouldRenderText) {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldRender(class_2586 blockEntity) {
        if (!masterOptimize) {
            return true;
        }
        if (!BlockEntityManager.isSupportedEntity(blockEntity)) {
            return true;
        }
        BlockEntityExt inst = (BlockEntityExt)blockEntity;
        if (!inst.getJustReceivedUpdate() && !BlockEntityManager.isSignEntity(blockEntity)) {
            return false;
        }
        return BlockEntityManager.isAnimating(blockEntity) ? BlockEntityManager.handleAnimating(blockEntity, inst) : BlockEntityManager.handleStatic(blockEntity, inst);
    }

    private static boolean handleAnimating(class_2586 blockEntity, BlockEntityExt inst) {
        long pos = blockEntity.method_11016().method_10063();
        if (!(blockEntity instanceof class_2625) && BlockEntityTracker.animMap.add(pos)) {
            inst.setRemoveChunkVariant(true);
            ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos);
        }
        return true;
    }

    private static boolean handleStatic(class_2586 blockEntity, BlockEntityExt inst) {
        int passes;
        long pos = blockEntity.method_11016().method_10063();
        if (ConfigManager.CONFIG.updateType == 0) {
            if (!BlockEntityTracker.animMap.contains(pos)) {
                return false;
            }
            class_4604 frustum = BetterBlockEntities.curFrustum;
            if (BlockVisibilityChecker.isBlockInFOVAndVisible(frustum, blockEntity)) {
                return true;
            }
        }
        if (BlockEntityTracker.animMap.remove(pos)) {
            inst.setRemoveChunkVariant(false);
            ChunkUpdateDispatcher.queueRebuildAtBlockPos(blockEntity.method_10997(), pos);
            BlockEntityTracker.extraRenderPasses.put(pos, smoothness);
        }
        return (passes = BlockEntityTracker.extraRenderPasses.compute(pos, (p, v) -> {
            if (v == null) {
                return null;
            }
            if (v > 1) {
                return v - 1;
            }
            inst.setJustReceivedUpdate(false);
            return null;
        })) != 0;
    }
}

