/*
 * Decompiled with CFR 0.152.
 */
package betterblockentities.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_5555;

public class BlockVisibilityChecker {
    private static final Map<Integer, class_243[]> GRID_CACHE = new HashMap<Integer, class_243[]>();

    public static boolean isBlockInFOVAndVisible(class_4604 frustum, class_2586 blockEntity) {
        class_1297 player = class_310.method_1551().method_1560();
        if (player == null) {
            return false;
        }
        class_243 eyePos = player.method_5836(1.0f);
        class_2338 pos = blockEntity.method_11016();
        class_1937 world = blockEntity.method_10997();
        class_238 box = BlockVisibilityChecker.setupBox(blockEntity, pos);
        double maxDistanceSq = 400.0;
        if (eyePos.method_1025(box.method_1005()) > maxDistanceSq) {
            return false;
        }
        if (!BlockVisibilityChecker.isBlockInViewFrustum(frustum, box)) {
            return false;
        }
        return BlockVisibilityChecker.hasLOS(world, eyePos, box);
    }

    private static boolean isBlockInViewFrustum(class_4604 frustum, class_238 box) {
        return frustum != null && frustum.method_23093(box);
    }

    private static boolean hasLOS(class_1937 world, class_243 eye, class_238 box) {
        class_243[] samplePoints;
        double distance = eye.method_1022(box.method_1005());
        int resolution = Math.max(2, 5 - (int)(distance / 4.0));
        for (class_243 offset : samplePoints = GRID_CACHE.computeIfAbsent(resolution, BlockVisibilityChecker::generateFaceGrid)) {
            class_243 target = new class_243(box.field_1323 + offset.field_1352 * box.method_17939(), box.field_1322 + offset.field_1351 * box.method_17940(), box.field_1321 + offset.field_1350 * box.method_17941());
            if (!BlockVisibilityChecker.raycastVoxel(world, eye, target)) continue;
            return true;
        }
        return false;
    }

    private static boolean raycastVoxel(class_1937 world, class_243 eye, class_243 target) {
        class_243 ray = target.method_1020(eye);
        double maxDistSq = ray.method_1027();
        double step = ray.method_1033() < 10.0 ? 0.25 : 0.35;
        class_243 dir = ray.method_1029().method_1021(step);
        class_243 cur = eye.method_1019(dir);
        while (eye.method_1025(cur) < maxDistSq) {
            class_2338 pos = class_2338.method_49638((class_2374)cur);
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            if (state.method_26167() && !state.method_26225() || block instanceof class_2354 || block instanceof class_2349 || block instanceof class_5555) {
                cur = cur.method_1019(dir);
                continue;
            }
            class_265 shape = state.method_26220((class_1922)world, pos);
            if (!shape.method_1110() && shape.method_1092(cur, target, pos) != null) {
                return false;
            }
            class_265 fluid = state.method_26227().method_17776((class_1922)world, pos);
            if (!fluid.method_1110() && fluid.method_1092(cur, target, pos) != null) {
                return false;
            }
            cur = cur.method_1019(dir);
        }
        return true;
    }

    private static class_243[] generateFaceGrid(int resolution) {
        ArrayList<class_243> list = new ArrayList<class_243>();
        double step = 1.0 / (double)(resolution - 1);
        for (int y = 0; y < resolution; ++y) {
            for (int x = 0; x < resolution; ++x) {
                double u = (double)x * step;
                double v = (double)y * step;
                list.add(new class_243(0.0, v, u));
                list.add(new class_243(1.0, v, u));
                list.add(new class_243(u, v, 0.0));
                list.add(new class_243(u, v, 1.0));
                list.add(new class_243(u, 0.0, v));
                list.add(new class_243(u, 1.0, v));
            }
        }
        return list.toArray(new class_243[0]);
    }

    private static class_238 setupBox(class_2586 be, class_2338 pos) {
        if (be instanceof class_2573) {
            return new class_238(pos).method_1009(0.0, 1.0, 0.0);
        }
        if (!(be instanceof class_2595)) {
            return new class_238(pos);
        }
        class_2338 other = BlockVisibilityChecker.getOtherChestHalf(be.method_10997(), pos);
        return other == null ? new class_238(pos) : new class_238(pos).method_991(new class_238(other));
    }

    private static class_2338 getOtherChestHalf(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof class_2281)) {
            return null;
        }
        class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        if (type == class_2745.field_12569) {
            return null;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
        class_2350 side = type == class_2745.field_12574 ? facing.method_10170() : facing.method_10160();
        class_2338 otherPos = pos.method_10093(side);
        if (world.method_8320(otherPos).method_26204() instanceof class_2281) {
            return otherPos;
        }
        return null;
    }
}

