/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import net.minecraft.class_11515;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.Nullable;

public final class CustomBlockLayers {
    public static final class_2960 LOCATION = class_2960.method_60656((String)"optifine/block.properties");
    private static final Predicate<class_2680>[] EMPTY_LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];
    private static final Predicate<class_2680>[] LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];
    private static boolean empty;
    private static boolean disableSolidCheck;

    public static boolean isEmpty() {
        return empty;
    }

    @Nullable
    public static class_11515 getLayer(class_2680 state) {
        if (!disableSolidCheck && state.method_26216()) {
            return null;
        }
        for (int i = 0; i < BlockLayer.VALUES.length; ++i) {
            Predicate<class_2680> predicate = LAYER_PREDICATES[i];
            if (predicate == null || !predicate.test(state)) continue;
            return BlockLayer.VALUES[i].getLayer();
        }
        return null;
    }

    private static void reload(class_3300 manager) {
        empty = true;
        System.arraycopy(EMPTY_LAYER_PREDICATES, 0, LAYER_PREDICATES, 0, EMPTY_LAYER_PREDICATES.length);
        disableSolidCheck = false;
        Optional optionalResource = manager.method_14486(LOCATION);
        if (optionalResource.isPresent()) {
            class_3298 resource = (class_3298)optionalResource.get();
            try (InputStream inputStream = resource.method_14482();){
                Properties properties = new Properties();
                properties.load(inputStream);
                CustomBlockLayers.reload(properties, LOCATION, resource.method_14480());
            }
            catch (IOException e) {
                ContinuityClient.LOGGER.error("Failed to load custom block layers from file '" + String.valueOf(LOCATION) + "' from pack '" + resource.method_14480() + "'", (Throwable)e);
            }
        }
    }

    private static void reload(Properties properties, class_2960 fileLocation, String packId) {
        for (BlockLayer blockLayer : BlockLayer.VALUES) {
            String propertyKey = "layer." + blockLayer.getKey();
            Predicate<class_2680> predicate = PropertiesParsingHelper.parseBlockStates(properties, propertyKey, fileLocation, packId);
            if (predicate == null || predicate == PropertiesParsingHelper.EMPTY_BLOCK_STATE_PREDICATE) continue;
            CustomBlockLayers.LAYER_PREDICATES[blockLayer.ordinal()] = predicate;
            empty = false;
        }
        String disableSolidCheckStr = properties.getProperty("disableSolidCheck");
        if (disableSolidCheckStr != null) {
            disableSolidCheck = Boolean.parseBoolean(disableSolidCheckStr.trim());
        }
    }

    private static enum BlockLayer {
        SOLID(class_11515.field_60923),
        CUTOUT(class_11515.field_60925),
        CUTOUT_MIPPED(class_11515.field_60924),
        TRANSLUCENT(class_11515.field_60926);

        public static final BlockLayer[] VALUES;
        private final class_11515 layer;
        private final String key;

        private BlockLayer(class_11515 layer) {
            this.layer = layer;
            this.key = this.name().toLowerCase(Locale.ROOT);
        }

        public class_11515 getLayer() {
            return this.layer;
        }

        public String getKey() {
            return this.key;
        }

        static {
            VALUES = BlockLayer.values();
        }
    }

    public static class ReloadListener
    implements class_4013 {
        public static final class_2960 ID = ContinuityClient.asId("custom_block_layers");
        public static final ReloadListener INSTANCE = new ReloadListener();

        public void method_14491(class_3300 manager) {
            CustomBlockLayers.reload(manager);
        }
    }
}

