/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SpriteLoaderLoadContextImpl
implements SpriteLoaderLoadContext {
    private final CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture;
    private final Map<class_2960, CompletableFuture<Set<class_2960>>> extraIdsFutures = new Object2ObjectOpenHashMap();
    private final SpriteLoaderLoadContext.EmissiveControl blockAtlasEmissiveControl;

    public SpriteLoaderLoadContextImpl(CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture, CompletableFuture<Boolean> blockAtlasHasEmissivesFuture) {
        this.allExtraIdsFuture = allExtraIdsFuture;
        this.blockAtlasEmissiveControl = new EmissiveControlImpl(blockAtlasHasEmissivesFuture);
    }

    @Override
    public CompletableFuture<@Nullable Set<class_2960>> getExtraIdsFuture(class_2960 atlasId) {
        return this.extraIdsFutures.computeIfAbsent(atlasId, id -> this.allExtraIdsFuture.thenApply(allExtraIds -> (Set)allExtraIds.get(id)));
    }

    @Override
    @Nullable
    public SpriteLoaderLoadContext.EmissiveControl getEmissiveControl(class_2960 atlasId) {
        if (atlasId.equals((Object)class_1059.field_5275)) {
            return this.blockAtlasEmissiveControl;
        }
        return null;
    }

    private static class EmissiveControlImpl
    implements SpriteLoaderLoadContext.EmissiveControl {
        @Nullable
        private volatile Map<class_2960, class_2960> emissiveIdMap;
        private final CompletableFuture<Boolean> hasEmissivesFuture;

        public EmissiveControlImpl(CompletableFuture<Boolean> hasEmissivesFuture) {
            this.hasEmissivesFuture = hasEmissivesFuture;
        }

        @Override
        @Nullable
        public Map<class_2960, class_2960> getEmissiveIdMap() {
            return this.emissiveIdMap;
        }

        @Override
        public void setEmissiveIdMap(Map<class_2960, class_2960> emissiveIdMap) {
            if (emissiveIdMap.isEmpty()) {
                this.hasEmissivesFuture.complete(false);
            } else {
                this.emissiveIdMap = emissiveIdMap;
            }
        }

        @Override
        public void setHasEmissives(boolean hasEmissives) {
            this.hasEmissivesFuture.complete(hasEmissives);
        }
    }
}

