/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleGroupAddition;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleVertexStorageAddition;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.SingleQuadParticleLayerAddition;
import fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncParticleRenderState;
import fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRenderBehavior;
import fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.ParticleLayerAttached;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.MemStackUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ParticleThreadLocal;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import net.minecraft.class_11938;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AsyncQuadParticleRenderState
extends class_11944
implements AsyncParticleRenderState {
    private final class_11938<class_3940> group;
    private class_9801 meshData;
    private class_9799 byteBufferBuilder;
    private final Map<class_3940.class_11941, class_11944.class_12042> preparedLayers = new Reference2ObjectArrayMap();
    private static final ParticleThreadLocal<Quaternionf> QUATERNION_LOCAL = ParticleThreadLocal.withInitial(Quaternionf::new);
    private static final ParticleThreadLocal<Vector3f> VECTOR3F_LOCAL = ParticleThreadLocal.withInitial(Vector3f::new);

    public AsyncQuadParticleRenderState(class_11938<class_3940> group) {
        this.group = group;
    }

    public void method_74316() {
        if (((ParticleGroupAddition)this.group).asyncparticles$getFuture() != null) {
            throw new IllegalStateException("submit() has not been called!");
        }
        this.freeBuffers();
        super.method_74316();
    }

    public void method_74323(@NotNull class_3940.class_11941 layer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
        ParticleLayerAttached attached = ((SingleQuadParticleLayerAddition)layer).asyncparticles$getAttached();
        attached.add(f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    }

    @Override
    public void afterAdd() {
        this.field_62946 = ParticleLayerAttached.getParticleCount();
        if (this.field_62946 == 0) {
            return;
        }
        this.field_62652.putAll(ParticleLayerAttached.getParticles());
        int vertexCount = this.field_62946 * 4;
        this.byteBufferBuilder = class_9799.method_72201((int)(vertexCount * class_290.field_1584.getVertexSize()));
        long target = this.byteBufferBuilder.method_60808(vertexCount * class_290.field_1584.getVertexSize());
        this.preparedLayers.clear();
        this.renderParticles(target);
        class_9799.class_9800 result = this.byteBufferBuilder.method_60807();
        if (result != null) {
            VertexFormat.class_5595 indexType = VertexFormat.class_5595.method_31972((int)vertexCount);
            this.meshData = new class_9801(result, new class_9801.class_4574(class_290.field_1584, vertexCount, VertexFormat.class_5596.field_27382.method_31973(vertexCount), VertexFormat.class_5596.field_27382, indexType));
        }
    }

    private void renderParticles(long targetAddress) {
        int j = 0;
        try (MemoryStack memoryStack = MemStackUtil.stackPush();){
            long offsetPtr = memoryStack.nmalloc(4);
            MemoryUtil.memPutInt((long)offsetPtr, (int)0);
            for (Map.Entry entry : this.field_62652.entrySet()) {
                class_11944.class_11946 storage = (class_11944.class_11946)entry.getValue();
                int count = storage.method_74756();
                if (count <= 0) continue;
                storage.method_74328((f, g, h, ix, jx, k, l, m, n, o, p, q, r, s) -> {
                    int targetOffset = MemoryUtil.memGetInt((long)offsetPtr);
                    this.renderRotatedQuad(targetAddress + (long)targetOffset, f, g, h, ix, jx, k, l, m, n, o, p, q, r, s);
                    MemoryUtil.memPutInt((long)offsetPtr, (int)(targetOffset + 112));
                });
                this.preparedLayers.put((class_3940.class_11941)entry.getKey(), new class_11944.class_12042(j, count * 6));
                j += count * 4;
            }
        }
    }

    public void renderParticles2(long targetAddress) {
        ForkJoinTask task;
        Set entries = this.field_62652.entrySet();
        ArrayList<Future> tasks = new ArrayList<Future>(AsyncRenderBehavior.THREADS);
        int j = 0;
        for (Map.Entry entry : entries) {
            class_11944.class_11946 storage = (class_11944.class_11946)entry.getValue();
            int count = storage.method_74756();
            if (count <= 0) continue;
            int slice = (count + 1023) / 1024;
            for (int i = 0; i < slice; ++i) {
                int start = i * 1024;
                int end = Math.min(start + 1024, count);
                long finalTarget = targetAddress;
                tasks.add(AsyncRenderBehavior.EXECUTOR.submit(() -> {
                    try (MemoryStack memoryStack = MemStackUtil.stackPush();){
                        long offsetPtr = memoryStack.nmalloc(4);
                        MemoryUtil.memPutInt((long)offsetPtr, (int)0);
                        ((ParticleVertexStorageAddition)storage).asyncparticles$slice(start, end).forEachParticle((f, g, h, ix, jx, k, l, m, n, o, p, q, r, s) -> {
                            int targetOffset = MemoryUtil.memGetInt((long)offsetPtr);
                            this.renderRotatedQuad(finalTarget + (long)targetOffset, f, g, h, ix, jx, k, l, m, n, o, p, q, r, s);
                            MemoryUtil.memPutInt((long)offsetPtr, (int)(targetOffset + 112));
                        });
                    }
                }));
                targetAddress += (long)(end - start) * 112L;
            }
            this.preparedLayers.put((class_3940.class_11941)entry.getKey(), new class_11944.class_12042(j, count * 6));
            j += count * 4;
        }
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext() && (task = (ForkJoinTask)((Object)iterator.next())) != null) {
            task.join();
        }
    }

    protected void renderRotatedQuad(long ptr, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, int r, int s) {
        Quaternionf quaternionf = QUATERNION_LOCAL.get();
        quaternionf.set(i, j, k, l);
        Vector3f vector3f = VECTOR3F_LOCAL.get();
        vector3f.set(1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr, vector3f, o, q, r, s);
        vector3f.set(1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, o, p, r, s);
        vector3f.set(-1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, n, p, r, s);
        vector3f.set(-1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(m).add(f, g, h);
        this.renderVertex(ptr += 28L, vector3f, n, q, r, s);
    }

    protected void renderVertex(long ptr, Vector3f vector3f, float l, float m, int n, int o) {
        MemoryUtil.memPutFloat((long)ptr, (float)vector3f.x);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)vector3f.y);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)vector3f.z);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)l);
        MemoryUtil.memPutFloat((long)(ptr += 4L), (float)m);
        MemoryUtil.memPutByte((long)(ptr += 4L), (byte)((byte)class_9848.method_61327((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)class_9848.method_61329((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)class_9848.method_61331((int)n)));
        MemoryUtil.memPutByte((long)(++ptr), (byte)((byte)class_9848.method_61320((int)n)));
        MemoryUtil.memPutShort((long)(++ptr), (short)((short)(o & 0xFFFF)));
        MemoryUtil.memPutShort((long)(ptr += 2L), (short)((short)(o >> 16 & 0xFFFF)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public class_11944.class_12041 method_74755(class_11977.class_12051 particleBufferCache) {
        if (((ParticleGroupAddition)this.group).asyncparticles$getFuture() != null) {
            throw new IllegalStateException("submit() has not been called!");
        }
        if (this.meshData == null) {
            this.freeBuffers();
            return null;
        }
        try {
            particleBufferCache.method_74835(this.meshData.method_60818());
            RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(this.meshData.method_60822().comp_751());
            GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
            class_11944.class_12041 class_120412 = new class_11944.class_12041(this.meshData.method_60822().comp_751(), gpuBufferSlice, this.preparedLayers);
            return class_120412;
        }
        finally {
            this.freeBuffers();
        }
    }

    private void freeBuffers() {
        if (this.byteBufferBuilder != null) {
            this.byteBufferBuilder.close();
            this.byteBufferBuilder = null;
            this.meshData = null;
        }
    }
}

