/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IterationSafeArrayList<E>
extends ObjectArrayList<E> {
    public IterationSafeArrayList() {
    }

    public IterationSafeArrayList(Collection<E> c) {
        super(c);
    }

    public IterationSafeArrayList(int i) {
        super(i);
    }

    public void removeElements(int from, int to) {
        it.unimi.dsi.fastutil.Arrays.ensureFromTo((int)this.size, (int)from, (int)to);
        if (to != this.size) {
            Object[] b = (Object[])Array.newInstance(this.a.getClass().getComponentType(), this.a.length);
            System.arraycopy(this.a, 0, b, 0, from);
            System.arraycopy(this.a, to, b, from, this.size - to);
            this.a = b;
        } else {
            Arrays.fill(this.a, from, to, null);
        }
        this.size -= to - from;
    }

    public void addElements(int index, E[] a, int offset, int length) {
        Object[] b;
        boolean addToTail;
        this.ensureIndex(index);
        ObjectArrays.ensureOffsetLength((Object[])a, (int)offset, (int)length);
        boolean bl = addToTail = index == this.size;
        if (addToTail) {
            b = this.a;
        } else {
            b = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
            System.arraycopy(this.a, 0, b, 0, index);
            System.arraycopy(this.a, index, b, index + length, this.size - index);
        }
        System.arraycopy(a, offset, b, index, length);
        this.size += length;
        if (!addToTail) {
            this.a = b;
        }
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] b;
        boolean addToTail;
        if (c instanceof ObjectList) {
            return this.addAll(index, (ObjectList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        boolean bl = addToTail = index == this.size;
        if (addToTail) {
            b = this.a;
        } else {
            b = (Object[])Array.newInstance(this.a.getClass().getComponentType(), Math.max(this.a.length, this.size + n));
            System.arraycopy(this.a, 0, b, 0, index);
            System.arraycopy(this.a, index, b, index + n, this.size - index);
        }
        Iterator<E> i = c.iterator();
        this.size += n;
        while (n-- != 0) {
            b[index++] = i.next();
        }
        assert (this.size <= b.length);
        if (!addToTail) {
            this.a = b;
        }
        return true;
    }

    public boolean addAll(int index, ObjectList<? extends E> l) {
        Object[] b;
        boolean addToTail;
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        boolean bl = addToTail = index == this.size;
        if (addToTail) {
            b = this.a;
        } else {
            b = (Object[])Array.newInstance(this.a.getClass().getComponentType(), Math.max(this.a.length, this.size + n));
            System.arraycopy(this.a, 0, b, 0, index);
            System.arraycopy(this.a, index, b, index + n, this.size - index);
        }
        l.getElements(0, b, index, n);
        this.size += n;
        assert (this.size <= b.length);
        if (!addToTail) {
            this.a = b;
        }
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        return this.removeIf(c::contains);
    }

    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        int i;
        Object[] a = this.a;
        int size = this.size;
        for (i = 0; i < size && !filter.test(a[i]); ++i) {
        }
        if (i == size) {
            return false;
        }
        Object[] b = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
        System.arraycopy(a, 0, b, 0, i);
        int j = i++;
        while (i < size) {
            Object e = a[i];
            if (!filter.test(e)) {
                b[j++] = e;
            }
            ++i;
        }
        this.a = b;
        this.size = j;
        return true;
    }

    @NotNull
    public ObjectListIterator<E> listIterator(int i) {
        int s = this.size();
        if (i < 0 || i > s) {
            throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + s);
        }
        if (s == 0) {
            return ObjectIterators.EMPTY_ITERATOR;
        }
        return new ListItr(this.a, s, i);
    }

    public Object @NotNull [] toArray() {
        Object[] es = this.a;
        int size = Math.min(es.length, this.size());
        return Arrays.copyOf(es, size, Object[].class);
    }

    public <K> K @NotNull [] toArray(K[] a) {
        Object[] es = this.a;
        int size = Math.min(es.length, this.size());
        if (a == null) {
            a = new Object[size];
        } else if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(es, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    private class ListItr
    implements ObjectListIterator<E> {
        private final E[] a;
        private int size;
        private int cursor;
        private int index;
        private E curr;
        private E prev;
        private E next;

        public ListItr(E[] es, int size, int i) {
            this.a = es;
            this.size = size;
            this.cursor = i;
            this.index = i;
        }

        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object prev = this.prev;
            this.next = null;
            this.prev = null;
            --this.index;
            this.curr = prev;
            return this.curr;
        }

        public boolean hasPrevious() {
            if (this.prev != null) {
                return true;
            }
            Object e = this.curr;
            while (this.cursor > 0) {
                if ((this.prev = this.a[--this.cursor]) == null || this.prev == e) continue;
                return true;
            }
            this.prev = null;
            return false;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            Object e = this.curr;
            while (this.cursor < this.size) {
                if ((this.next = this.a[this.cursor++]) == null || this.next == e) continue;
                return true;
            }
            this.next = null;
            return false;
        }

        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.next;
            this.next = null;
            this.prev = null;
            ++this.index;
            this.curr = next;
            return this.curr;
        }

        public void remove() {
            int i;
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            for (i = this.cursor; i >= 0 && this.a[i] != this.curr; --i) {
            }
            if (i < 0) {
                throw new IllegalStateException();
            }
            IterationSafeArrayList.this.remove(i);
            --this.size;
            this.curr = null;
        }
    }
}

