/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IterationSafeEvictingQueue<E>
implements Queue<E> {
    public static final int MAX_CAPACITY = 0x40000000;
    protected Object[] queue;
    protected final int maxCapacity;
    protected final int maxCapacityPowerOfTwo;
    protected final Consumer<E> onEvict;
    protected int head;
    protected int size;

    public IterationSafeEvictingQueue(int initialCapacity, int maxCapacity) {
        this(initialCapacity, maxCapacity, e -> {});
    }

    public IterationSafeEvictingQueue(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        if (initialCapacity < 0 || maxCapacity <= 0 || initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("Invalid capacities, initialCapacity: " + initialCapacity + ", maxCapacity: " + maxCapacity);
        }
        this.queue = new Object[IterationSafeEvictingQueue.roundUpToPowerOfTwo(Math.max(8, initialCapacity))];
        this.maxCapacity = maxCapacity;
        this.maxCapacityPowerOfTwo = IterationSafeEvictingQueue.roundUpToPowerOfTwo(maxCapacity);
        this.onEvict = onEvict;
        this.head = 0;
        this.size = 0;
    }

    public static <E> IterationSafeEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity) {
        return new IterationSafeEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity);
    }

    public static <E> IterationSafeEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        return new IterationSafeEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity, onEvict);
    }

    @Override
    public boolean offer(E item) {
        if (item == null) {
            throw new NullPointerException("Item cannot be null");
        }
        Object[] q = this.queue;
        int capacity = q.length;
        int size = this.size;
        if (size >= this.maxCapacity) {
            int head = this.head;
            int mask = capacity - 1;
            this.head = head + 1 & mask;
            Object evicted = q[head];
            if (evicted != null) {
                this.onEvict.accept(evicted);
            }
            q[head] = null;
            q[head + size & mask] = item;
        } else {
            if (capacity == size) {
                q = this.resize(capacity <<= 1);
            }
            q[this.head + size & capacity - 1] = item;
            ++this.size;
        }
        return true;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        Object[] q = this.queue;
        int head = this.head;
        Object item = q[head];
        this.head = head + 1 & q.length - 1;
        q[head] = null;
        --this.size;
        return (E)item;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        while (true) {
            Object[] queue;
            int head;
            if ((head = this.head) >= (queue = this.queue).length) {
                Thread.yield();
                continue;
            }
            Object o = queue[head];
            if (o != null) {
                return (E)o;
            }
            if (this.size == 0) break;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return new aSpliterator();
    }

    public Iterator<E> conditionalIterator(final Predicate<E> predicate) {
        return new anIterator(this){

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                Object e = this.curr;
                while (this.cursor < this.tail) {
                    this.next = this.a[this.cursor++ & this.mask];
                    if (this.next == null || this.next == e || !predicate.test(this.next)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private Object[] resize(int newCapacity) {
        if (newCapacity > this.maxCapacityPowerOfTwo) {
            throw new IllegalStateException("Cannot increase capacity beyond max capacity " + this.maxCapacityPowerOfTwo + " : " + newCapacity);
        }
        Object[] q = this.queue;
        int head = this.head;
        int tail = head + this.size;
        int capacity = q.length;
        Object[] a = new Object[newCapacity];
        if (tail <= capacity) {
            System.arraycopy(q, head, a, head, this.size);
        } else {
            int l = capacity - head;
            System.arraycopy(q, head, a, 0, l);
            System.arraycopy(q, 0, a, l, tail - capacity);
        }
        this.queue = a;
        this.head = 0;
        return a;
    }

    public int arraySize() {
        return this.queue.length;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new anIterator();
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public E remove() {
        E item = this.poll();
        if (item == null) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public E element() {
        E item = this.peek();
        if (item == null) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.removeIf(c::contains);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.removeIf(e -> !c.contains(e));
    }

    public void parallelRemoveIf(@NotNull Predicate<? super E> filter, boolean parallelEvicting, int threads, ExecutorService executor) {
        if (parallelEvicting) {
            this.parallelRemoveIfParallelEvicting(filter, threads, executor);
        } else {
            this.parallelRemoveIfSequencedEvicting(filter, threads, executor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parallelRemoveIfSequencedEvicting(Predicate<? super E> filter, int threads, ExecutorService executor) {
        void var12_20;
        int pos;
        void var12_18;
        Object[] a = this.queue;
        int mask = a.length - 1;
        int size = this.size;
        int head = this.head;
        int chunkSize = (size + threads - 1) / threads;
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        ArrayList futures = new ArrayList(threads);
        int i2 = 0;
        while (i2 < threads) {
            int n = i2++;
            futures.add(executor.submit(() -> {
                int start = finalI * chunkSize;
                int end = Math.min(start + chunkSize, size);
                for (int j = start; j < end; ++j) {
                    int index = head + j & mask;
                    Object e = a[index];
                    if (!filter.test((Object)e)) continue;
                    a[index] = null;
                    queue.add(e);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Object e : queue) {
            this.onEvict.accept(e);
        }
        int newSize = 0;
        boolean bl = false;
        while (var12_18 < size) {
            pos = head + var12_18 & mask;
            Object e = a[pos];
            if (e != null) {
                a[head + newSize++ & mask] = e;
            }
            ++var12_18;
        }
        int n = newSize;
        while (var12_20 < size) {
            pos = head + var12_20 & mask;
            a[pos] = null;
            ++var12_20;
        }
        this.size = newSize;
    }

    /*
     * WARNING - void declaration
     */
    private void parallelRemoveIfParallelEvicting(Predicate<? super E> filter, int threads, ExecutorService executor) {
        void var11_18;
        int pos;
        void var11_16;
        Object[] a = this.queue;
        int mask = a.length - 1;
        int size = this.size;
        int head = this.head;
        int chunkSize = (size + threads - 1) / threads;
        ArrayList futures = new ArrayList(threads);
        int i2 = 0;
        while (i2 < threads) {
            int n = i2++;
            futures.add(executor.submit(() -> {
                int start = finalI * chunkSize;
                int end = Math.min(start + chunkSize, size);
                for (int j = start; j < end; ++j) {
                    int index = head + j & mask;
                    Object e = a[index];
                    if (!filter.test((E)e)) continue;
                    a[index] = null;
                    this.onEvict.accept(e);
                }
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        int newSize = 0;
        boolean bl = false;
        while (var11_16 < size) {
            pos = head + var11_16 & mask;
            Object e = a[pos];
            if (e != null) {
                a[head + newSize++ & mask] = e;
            }
            ++var11_16;
        }
        int n = newSize;
        while (var11_18 < size) {
            pos = head + var11_18 & mask;
            a[pos] = null;
            ++var11_18;
        }
        this.size = newSize;
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        int i;
        Object[] a = this.queue;
        int mask = a.length - 1;
        int to = this.size + i;
        for (i = this.head; i < to; ++i) {
            Object e = a[i & mask];
            if (!filter.test(e)) continue;
            this.onEvict.accept(e);
            break;
        }
        if (i == to) {
            return false;
        }
        a[i & mask] = null;
        int j = i++;
        while (i < to) {
            int i1 = i & mask;
            Object e = a[i1];
            if (!filter.test(e)) {
                a[j++ & mask] = e;
            } else {
                this.onEvict.accept(e);
            }
            a[i1] = null;
            ++i;
        }
        this.size = j - this.head;
        return true;
    }

    private void removeIndex(Object[] q, int toRemove, int tail) {
        int l = tail - toRemove;
        int mask = q.length - 1;
        if (l > 0) {
            if (tail <= q.length) {
                System.arraycopy(q, toRemove + 1, q, toRemove, l - 1);
            } else if (toRemove <= mask) {
                if (toRemove < mask) {
                    System.arraycopy(q, toRemove + 1, q, toRemove, q.length - toRemove - 1);
                }
                q[mask] = q[0];
                System.arraycopy(q, 1, q, 0, tail - q.length - 1);
            } else {
                System.arraycopy(q, toRemove + 1 & mask, q, toRemove & mask, l - 1);
            }
        }
        q[tail - 1 & mask] = null;
        --this.size;
    }

    @Override
    public void clear() {
        int head = this.head;
        int tail = head + this.size;
        Object[] q = this.queue;
        int capacity = q.length;
        if (tail <= capacity) {
            Arrays.fill(q, head, tail, null);
        } else {
            Arrays.fill(q, head, capacity, null);
            Arrays.fill(q, 0, tail - capacity, null);
        }
        this.head = 0;
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        Object[] q = this.queue;
        int mask = q.length - 1;
        int to = i + this.size;
        for (i = this.head; i < to; ++i) {
            if (!o.equals(q[i & mask])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public <T> T @NotNull [] toArray(T[] a) {
        Object[] q;
        int capacity;
        int head;
        int tail;
        int size = this.size;
        if (size > a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if ((tail = (head = this.head) + size) <= (capacity = (q = this.queue).length)) {
            System.arraycopy(q, head, a, 0, size);
        } else {
            int l = capacity - head;
            System.arraycopy(q, head, a, 0, l);
            System.arraycopy(q, 0, a, l, tail - capacity);
        }
        if (size < a.length) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        Object[] q = this.queue;
        int mask = q.length - 1;
        int to = this.size + i;
        for (i = this.head; i < to; ++i) {
            int index = i & mask;
            if (!o.equals(q[index])) continue;
            this.removeIndex(q, i, to);
            return true;
        }
        return false;
    }

    private static int roundUpToPowerOfTwo(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive: " + n);
        }
        if (n > 0x40000000) {
            throw new IllegalArgumentException("n cannot larger than 1073741824 : " + n);
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<E> it = this.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", ");
                sb.append(it.next());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private final class aSpliterator
    implements Spliterator<E> {
        int pos;
        int max;

        private aSpliterator(int pos, int max) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
        }

        private aSpliterator() {
            Object[] a = IterationSafeEvictingQueue.this.queue;
            this.pos = Math.min(a.length - 1, IterationSafeEvictingQueue.this.head);
            this.max = Math.min(a.length, IterationSafeEvictingQueue.this.size) + this.pos;
        }

        @Override
        public int characteristics() {
            return 16464;
        }

        @Override
        public long estimateSize() {
            return this.max - this.pos;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int mask = IterationSafeEvictingQueue.this.queue.length - 1;
            action.accept(IterationSafeEvictingQueue.this.queue[this.pos++ & mask]);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int max;
            Object[] a = IterationSafeEvictingQueue.this.queue;
            this.pos = max = this.max;
            int mask = IterationSafeEvictingQueue.this.queue.length - 1;
            for (int pos = this.pos; pos < max; ++pos) {
                Object e = a[pos & mask];
                if (e == null) continue;
                action.accept(e);
            }
        }

        @Override
        public Spliterator<E> trySplit() {
            int newPos;
            int max = this.max;
            int pos = this.pos;
            int retLen = max - pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.pos = newPos = pos + retLen;
            return new aSpliterator(pos, newPos);
        }
    }

    private class anIterator
    implements Iterator<E> {
        protected final Object[] a;
        protected final int mask;
        protected final int head;
        protected int tail;
        protected int cursor;
        protected Object curr;
        protected Object next;

        private anIterator() {
            this.a = IterationSafeEvictingQueue.this.queue;
            this.mask = this.a.length - 1;
            this.head = Math.min(this.mask, IterationSafeEvictingQueue.this.head);
            this.tail = Math.min(this.a.length, IterationSafeEvictingQueue.this.size) + this.head;
            this.cursor = this.head;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            Object e = this.curr;
            while (this.cursor < this.tail) {
                this.next = this.a[this.cursor++ & this.mask];
                if (this.next == null || this.next == e) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.next;
            this.next = null;
            this.curr = next;
            return this.curr;
        }

        @Override
        public void remove() {
            int i;
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            for (i = this.cursor - 1; i >= this.head && this.a[i & this.mask] != this.curr; --i) {
            }
            if (i < 0) {
                throw new IllegalStateException();
            }
            IterationSafeEvictingQueue.this.removeIndex(this.a, i, this.tail);
            --this.tail;
            this.curr = null;
        }
    }
}

