/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.core;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRenderBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import org.slf4j.Logger;

public class VertexHelper {
    private static boolean warnedIllegalAlpha = false;
    private static boolean warnedIllegalColor = false;
    private static final Logger LOGGER = LogUtils.getLogger();

    public static VertexConsumer setColor(VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        if (alpha < 0.0f) {
            if (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread()) {
                if (!warnedIllegalAlpha) {
                    LOGGER.warn("Negative alpha value {} detected. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(alpha), (Object)new IllegalStateException(""));
                    warnedIllegalAlpha = true;
                }
                alpha = 0.0f;
            }
        } else if (alpha > 1.0f && (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread())) {
            if (!warnedIllegalAlpha) {
                LOGGER.warn("Alpha value {} is greater than 1. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(alpha), (Object)new IllegalStateException(""));
                warnedIllegalAlpha = true;
            }
            alpha = 1.0f;
        }
        return vertexConsumer.setColor((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public static float getAlpha(float alpha) {
        if (alpha < 0.0f) {
            if (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread()) {
                if (!warnedIllegalAlpha) {
                    LOGGER.warn("Negative alpha value {} detected. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(alpha), (Object)new IllegalStateException(""));
                    warnedIllegalAlpha = true;
                }
                alpha = 0.0f;
            }
        } else if (alpha > 1.0f && (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread())) {
            if (!warnedIllegalAlpha) {
                LOGGER.warn("Alpha value {} is greater than 1. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(alpha), (Object)new IllegalStateException(""));
                warnedIllegalAlpha = true;
            }
            alpha = 1.0f;
        }
        return alpha;
    }

    public static float getColor(float color) {
        if (color < 0.0f) {
            if (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread()) {
                if (!warnedIllegalColor) {
                    LOGGER.warn("Negative color value {} detected. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(color), (Object)new IllegalStateException(""));
                    warnedIllegalColor = true;
                }
                color = 0.0f;
            }
        } else if (color > 1.0f && (AsyncRenderBehavior.isParticlePhase() && ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleRendererThread())) {
            if (!warnedIllegalColor) {
                LOGGER.warn("Color value {} is greater than 1. This may cause unexpected behavior. You can ignore it if nothing is broken.", (Object)Float.valueOf(color), (Object)new IllegalStateException(""));
                warnedIllegalColor = true;
            }
            color = 1.0f;
        }
        return color;
    }
}

