/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick;

import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.Mappings;
import net.minecraft.client.particle.ParticleGroup;

public class AsyncTickParticleGroupBehavior {
    public static final String TICK_PARTICLES_METHOD;
    private static final Set<Class<ParticleGroup>> ASYNC_TICKABLE_PARTICLE_GROUP_CLASSES;
    private static final Reference2BooleanOpenHashMap<Class<? extends ParticleGroup>> CAN_TICK_PARTICLES_ASYNC;

    public static boolean canTickAsync(ParticleGroup<?> particleGroup) {
        return CAN_TICK_PARTICLES_ASYNC.computeIfAbsent(particleGroup.getClass(), k -> {
            try {
                Class<?> declaringClass = k.getMethod(TICK_PARTICLES_METHOD, new Class[0]).getDeclaringClass();
                return ASYNC_TICKABLE_PARTICLE_GROUP_CLASSES.contains(declaringClass);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        });
    }

    static {
        CAN_TICK_PARTICLES_ASYNC = new Reference2BooleanOpenHashMap();
        ASYNC_TICKABLE_PARTICLE_GROUP_CLASSES = new ReferenceOpenHashSet(Set.of(ParticleGroup.class));
        TICK_PARTICLES_METHOD = Mappings.getTickParticlesMethod();
    }
}

