/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.core.particle.async_tick;

import com.google.common.collect.EvictingQueue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleGroupAddition;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick.AsyncTickBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import net.minecraft.ReportedException;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleGroup.class})
public abstract class MixinParticleGroup
implements ParticleGroupAddition {
    @Mutable
    @Shadow
    @Final
    protected Queue<? extends Particle> particles;
    @Unique
    private CompletableFuture<Void> asyncparticles$future;

    @Shadow
    protected abstract void tickParticle(Particle var1);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", remap=false, target="Lcom/google/common/collect/EvictingQueue;create(I)Lcom/google/common/collect/EvictingQueue;"))
    private EvictingQueue<?> redirectNewQueue(int maxSize, @Share(value="maxSize") LocalIntRef maxSizeRef) {
        maxSizeRef.set(maxSize);
        return null;
    }

    @Inject(method={"<init>"}, at={@At(value="FIELD", opcode=181, shift=At.Shift.AFTER, target="Lnet/minecraft/client/particle/ParticleGroup;particles:Ljava/util/Queue;")})
    private void injectNewQueue(ParticleEngine particleEngine, CallbackInfo ci, @Share(value="maxSize") LocalIntRef maxSizeRef) {
        this.particles = new IterationSafeEvictingQueue<Particle>(16, maxSizeRef.get(), AsyncTickBehavior::onEvict);
    }

    @Overwrite
    public void tickParticles() {
        boolean enableLightCache = ConfigHelper.isParticleLightCache();
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        boolean forceDone = ConfigHelper.forceDoneParticleTick();
        for (Particle particle : this.particles) {
            block16: {
                if (AsyncTickBehavior.isCancelled() && !forceDone) {
                    return;
                }
                if (!particle.isAlive()) {
                    Utils.DUMMY_ITERATOR.remove();
                    continue;
                }
                if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                        }
                    }
                    continue;
                }
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) continue;
                try {
                    this.tickParticle(particle);
                }
                catch (Throwable t) {
                    ReportedException re = AsyncTickBehavior.onTickParticleException(particle, t);
                    if (re == null) break block16;
                    throw re;
                }
            }
            ((ParticleAddon)particle).asyncparticles$setTicked();
            if (enableLightCache) {
                ((LightCachedParticleAddon)particle).asyncparticles$refresh();
            }
            switch (particleCullingMode) {
                case ASYNC_AABB: {
                    ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                    break;
                }
                case ASYNC_SPHERE: {
                    ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                }
            }
        }
    }

    @Override
    public void asyncparticles$cleanUp() {
        if (ConfigHelper.isParallelQueueRemoval()) {
            ((IterationSafeEvictingQueue)this.particles).parallelRemoveIf(particle -> AsyncTickBehavior.shouldRemove(particle, ConfigHelper.isRemoveIfMissedTick()), ConfigHelper.isParallelQueueEviction(), AsyncTickBehavior.THREADS, AsyncTickBehavior.EXECUTOR);
        } else {
            this.particles.removeIf(particle -> AsyncTickBehavior.shouldRemove(particle, ConfigHelper.isRemoveIfMissedTick()));
        }
    }

    @Override
    public void asyncparticles$setFuture(CompletableFuture<Void> future) {
        this.asyncparticles$future = future;
    }

    @Override
    public CompletableFuture<Void> asyncparticles$getFuture() {
        return this.asyncparticles$future;
    }
}

