/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import customskinloader.CustomSkinLoader;
import customskinloader.fake.texture.FakeBufferedImage;
import customskinloader.fake.texture.FakeImage;
import customskinloader.fake.texture.FakeNativeImage;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_760;

public class FakeSkinBuffer
implements class_760 {
    FakeImage image = null;
    static final Function<Integer, Predicate<Integer>> EQU_BG = bgColor -> FakeSkinBuffer.getA(bgColor) == 0 ? c -> FakeSkinBuffer.getA(c) == 0 : c -> c.equals(bgColor);
    private static final int A = 0xFFFFFF;
    private static final int WHITE = FakeSkinBuffer.getARGB(255, 255, 255, 255);
    private static final int BLACK = FakeSkinBuffer.getARGB(255, 0, 0, 0);
    private static final int B = -16777216;

    public static class_1011 processLegacySkin(class_1011 image, String url) {
        if (image == null) {
            return null;
        }
        FakeImage img = FakeSkinBuffer.parseUserSkin0(new FakeNativeImage(image));
        if (img instanceof FakeNativeImage) {
            return FakeNativeImage.Extended.create((FakeNativeImage)img);
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin(downloadAndRegisterSkin).");
        return null;
    }

    public static class_1011 processLegacySkin(class_1011 image, Runnable processTask, Function<class_1011, class_1011> processLegacySkin) {
        if (processTask instanceof class_760) {
            return ((class_760)processTask).method_3237(image);
        }
        if (processLegacySkin != null) {
            return processLegacySkin.apply(image);
        }
        return image;
    }

    @Override
    public class_1011 method_3237(class_1011 image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeNativeImage(image));
        if (img instanceof FakeNativeImage) {
            return ((FakeNativeImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin(func_195786_a).");
        return null;
    }

    @Override
    public BufferedImage func_78432_a(BufferedImage image) {
        if (image == null) {
            return null;
        }
        FakeImage img = this.parseUserSkin(new FakeBufferedImage(image));
        if (img instanceof FakeBufferedImage) {
            return ((FakeBufferedImage)img).getImage();
        }
        CustomSkinLoader.logger.warning("Failed to parseUserSkin.");
        return null;
    }

    public FakeImage parseUserSkin(FakeImage image) {
        this.image = FakeSkinBuffer.parseUserSkin0(image);
        return this.image;
    }

    public static FakeImage parseUserSkin0(FakeImage image) {
        if (image == null) {
            return null;
        }
        int ratio = image.getWidth() / 64;
        if (image.getHeight() != image.getWidth()) {
            FakeImage img = image.createImage(64 * ratio, 64 * ratio);
            img.copyImageData(image);
            image.close();
            image = img;
            image.fillArea(0 * ratio, 32 * ratio, 64 * ratio, 32 * ratio);
            image.copyArea(4 * ratio, 16 * ratio, 16 * ratio, 32 * ratio, 4 * ratio, 4 * ratio, true, false);
            image.copyArea(8 * ratio, 16 * ratio, 16 * ratio, 32 * ratio, 4 * ratio, 4 * ratio, true, false);
            image.copyArea(0 * ratio, 20 * ratio, 24 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(4 * ratio, 20 * ratio, 16 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(8 * ratio, 20 * ratio, 8 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(12 * ratio, 20 * ratio, 16 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(44 * ratio, 16 * ratio, -8 * ratio, 32 * ratio, 4 * ratio, 4 * ratio, true, false);
            image.copyArea(48 * ratio, 16 * ratio, -8 * ratio, 32 * ratio, 4 * ratio, 4 * ratio, true, false);
            image.copyArea(40 * ratio, 20 * ratio, 0 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(44 * ratio, 20 * ratio, -8 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(48 * ratio, 20 * ratio, -16 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
            image.copyArea(52 * ratio, 20 * ratio, -8 * ratio, 32 * ratio, 4 * ratio, 12 * ratio, true, false);
        }
        FakeSkinBuffer.setAreaDueToConfig(image, 0 * ratio, 0 * ratio, 32 * ratio, 16 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 32 * ratio, 0 * ratio, 64 * ratio, 16 * ratio);
        FakeSkinBuffer.setAreaDueToConfig(image, 16 * ratio, 16 * ratio, 40 * ratio, 32 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 16 * ratio, 32 * ratio, 40 * ratio, 48 * ratio);
        FakeSkinBuffer.setAreaDueToConfig(image, 40 * ratio, 16 * ratio, 56 * ratio, 32 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 40 * ratio, 32 * ratio, 56 * ratio, 48 * ratio);
        FakeSkinBuffer.setAreaDueToConfig(image, 0 * ratio, 16 * ratio, 16 * ratio, 32 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 0 * ratio, 32 * ratio, 16 * ratio, 48 * ratio);
        FakeSkinBuffer.setAreaDueToConfig(image, 32 * ratio, 48 * ratio, 48 * ratio, 64 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 48 * ratio, 48 * ratio, 64 * ratio, 64 * ratio);
        FakeSkinBuffer.setAreaDueToConfig(image, 16 * ratio, 48 * ratio, 32 * ratio, 64 * ratio);
        FakeSkinBuffer.setAreaTransparent(image, 0 * ratio, 48 * ratio, 16 * ratio, 64 * ratio);
        image.setRatio(ratio);
        return image;
    }

    public String judgeType() {
        return FakeSkinBuffer.judgeType0(this.image);
    }

    public static String judgeType0(FakeImage image) {
        if (image == null) {
            return "default";
        }
        int ratio = image.getRatio();
        int bgColor = image.getRGBA(63 * ratio, 20 * ratio);
        Predicate<Integer> predicate = EQU_BG.apply(bgColor);
        for (int x = 54 * ratio; x <= 55 * ratio; ++x) {
            for (int y = 20 * ratio; y <= 31 * ratio; ++y) {
                int color = image.getRGBA(x, y);
                if (predicate.test(color)) continue;
                return "default";
            }
        }
        return "slim";
    }

    private static boolean isFilled(FakeImage image, int x0, int y0, int x1, int y1) {
        int data = image.getRGBA(x0, y0);
        if (data != WHITE && data != BLACK) {
            return false;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                if (image.getRGBA(x, y) == data) continue;
                return false;
            }
        }
        return true;
    }

    private static void setAreaTransparent(FakeImage image, int x0, int y0, int x1, int y1) {
        if (!FakeSkinBuffer.isFilled(image, x0, y0, x1, y1)) {
            return;
        }
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                image.setRGBA(x, y, image.getRGBA(x, y) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(FakeImage image, int x0, int y0, int x1, int y1) {
        for (int x = x0; x < x1; ++x) {
            for (int y = y0; y < y1; ++y) {
                image.setRGBA(x, y, image.getRGBA(x, y) | 0xFF000000);
            }
        }
    }

    private static void setAreaDueToConfig(FakeImage image, int x0, int y0, int x1, int y1) {
        if (CustomSkinLoader.config.enableTransparentSkin) {
            FakeSkinBuffer.setAreaTransparent(image, x0, y0, x1, y1);
        } else {
            FakeSkinBuffer.setAreaOpaque(image, x0, y0, x1, y1);
        }
    }

    @Override
    public void method_3238() {
    }

    private static int getARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int getA(int argb) {
        return (argb & 0xFF000000) >>> 24;
    }
}

