/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde;

import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.NullObject;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.UnmodifiableConfig;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.DeserializerContext;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.SerdeException;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.TypeConstraint;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.ValueDeserializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ConfigToPojoDeserializer
implements ValueDeserializer<UnmodifiableConfig, Object> {
    ConfigToPojoDeserializer() {
    }

    @Override
    public Object deserialize(UnmodifiableConfig value, Optional<TypeConstraint> resultType, DeserializerContext ctx) {
        if (!resultType.isPresent()) {
            return value;
        }
        TypeConstraint t = resultType.get();
        Class<?> cls = t.getSatisfyingRawType().orElseThrow(() -> new SerdeException("Could not find a concrete type that can satisfy the constraint " + t));
        if (cls.isRecord()) {
            return this.deserializeToRecord(value, cls);
        }
        return this.deserializeToNormalClass(value, cls, ctx);
    }

    private Object deserializeToNormalClass(UnmodifiableConfig value, Class<?> cls, DeserializerContext ctx) {
        Object instance;
        try {
            Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            instance = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SerdeException("Failed to create an instance of " + cls, e);
        }
        ctx.deserializeFields(value, instance);
        return instance;
    }

    private Object deserializeToRecord(UnmodifiableConfig value, Class<?> objectClass) {
        RecordComponent[] components = objectClass.getRecordComponents();
        Constructor<?> constructor = ConfigToPojoDeserializer.getCanonicalRecordConstructor(objectClass, components);
        Object[] componentValues = new Object[components.length];
        for (int i = 0; i < components.length; ++i) {
            RecordComponent comp = components[i];
            Object configValue = value.getRaw(Collections.singletonList(comp.getName()));
            if (configValue == null) {
                List missingComponents = Arrays.stream(components).map(c -> c.getName()).filter(c -> !value.contains((String)c)).collect(Collectors.toList());
                String missingComponentsStr = String.join((CharSequence)", ", missingComponents);
                throw new SerdeException("Could not deserialize this configuration to a record of type " + objectClass + " because the following components (entries) are missing: " + missingComponentsStr);
            }
            if (configValue == NullObject.NULL_OBJECT) {
                configValue = null;
            }
            componentValues[i] = configValue;
        }
        try {
            return constructor.newInstance(componentValues);
        }
        catch (Exception e) {
            throw new SerdeException("Failed to create an instance of record " + objectClass, e);
        }
    }

    private static Constructor<?> getCanonicalRecordConstructor(Class<?> cls, RecordComponent[] components) {
        Class[] paramTypes = (Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            return cls.getDeclaredConstructor(paramTypes);
        }
        catch (Exception e) {
            throw new SerdeException("Failed to get the canonical constructor of record " + cls, e);
        }
    }
}

