/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass;

import dev.lambdaurora.lambdabettergrass.LBGMode;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.CommentedConfig;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.Config;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.io.ParsingException;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.io.ParsingMode;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.toml.TomlParser;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.toml.TomlWriter;
import dev.yumi.mc.core.api.YumiMods;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBGConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambdaBetterGrass|Config");
    private static final LBGMode DEFAULT_MODE = LBGMode.FANCY;
    private static final boolean DEFAULT_BETTER_LAYER = true;
    private static final boolean DEFAULT_DEBUG = false;
    public static final Path CONFIG_FILE_PATH = YumiMods.get().getConfigDirectory().resolve("lambdabettergrass.toml").normalize();
    private final CommentedConfig config;
    private final LambdaBetterGrass mod;
    private LBGMode mode;
    private boolean betterLayer;

    public LBGConfig(@NotNull LambdaBetterGrass mod) {
        this.mod = mod;
        this.config = CommentedConfig.inMemory();
    }

    public void load() {
        try {
            this.loadFromFile(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mode = LBGMode.byId(this.config.getOrElse("mode", DEFAULT_MODE.getName())).orElse(DEFAULT_MODE);
        this.betterLayer = this.config.getOrElse("better_layer", Boolean.valueOf(true));
        LambdaBetterGrass.log(LOGGER, "Configuration loaded.");
    }

    private void loadFromFile(boolean firstAttempt) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE_PATH);){
            new TomlParser().parse(reader, (Config)this.config, ParsingMode.REPLACE);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            if (!firstAttempt) {
                throw e;
            }
            this.copyDefaultFile();
            this.loadFromFile(false);
        }
        catch (ParsingException e) {
            if (!firstAttempt) {
                throw e;
            }
            Path backupPath = CONFIG_FILE_PATH.resolveSibling("lambdabettergrass.toml.old").toAbsolutePath().normalize();
            LambdaBetterGrass.error(LOGGER, "Failed to parse configuration file, THIS IS BAD.", e);
            LambdaBetterGrass.error(LOGGER, "Copying the corrupt file to \"{}\".", backupPath);
            Files.copy(CONFIG_FILE_PATH, backupPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.copyDefaultFile();
            this.loadFromFile(false);
        }
    }

    private void copyDefaultFile() throws IOException {
        Files.createDirectories(CONFIG_FILE_PATH.getParent(), new FileAttribute[0]);
        try (InputStream defaultStream = LBGConfig.class.getResourceAsStream("/lambdabettergrass.toml");){
            Files.copy(Objects.requireNonNull(defaultStream, "This distribution of LambdaBetterGrass is broken: cannot find the default configuration file inside of the mod's JAR."), CONFIG_FILE_PATH, StandardCopyOption.REPLACE_EXISTING);
            LambdaBetterGrass.log(LOGGER, "Copied default configuration file.");
        }
    }

    public void save() {
        String toml = new TomlWriter().writeToString(this.config);
        try {
            Files.createDirectories(CONFIG_FILE_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_FILE_PATH, (CharSequence)toml, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DSYNC);
        }
        catch (IOException e) {
            LambdaBetterGrass.error(LOGGER, "Failed to save configuration file.", e);
            return;
        }
        LambdaBetterGrass.log(LOGGER, "Configuration saved.");
    }

    public void reset() {
        this.setMode(DEFAULT_MODE);
        this.setBetterLayer(true);
        this.setDebug(false);
    }

    public LBGMode getMode() {
        return this.mode;
    }

    public void setMode(@NotNull LBGMode mode) {
        this.mode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public boolean hasBetterLayer() {
        return this.betterLayer;
    }

    public void setBetterLayer(boolean betterSnow) {
        this.betterLayer = betterSnow;
        this.config.set("better_layer", (Object)betterSnow);
    }

    public boolean isDebug() {
        return this.config.getOrElse("debug", Boolean.valueOf(false));
    }

    public void setDebug(boolean debug) {
        this.config.set("debug", (Object)debug);
    }
}

