/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass;

import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.LBGConfig;
import dev.lambdaurora.lambdabettergrass.metadata.LBGGrassState;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerState;
import dev.lambdaurora.lambdabettergrass.resource.LBGDynamicTextureManager;
import dev.lambdaurora.lambdabettergrass.resource.LBGResourceReloader;
import dev.yumi.mc.core.api.ModContainer;
import dev.yumi.mc.core.api.YumiMods;
import dev.yumi.mc.core.api.entrypoint.client.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1087;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LambdaBetterGrass
implements ClientModInitializer {
    public static final String NAMESPACE = "lambdabettergrass";
    public static final Logger LOGGER = LogUtils.getLogger();
    @ApiStatus.Internal
    public static final LambdaBetterGrass INSTANCE = new LambdaBetterGrass();
    public final LBGConfig config = new LBGConfig(this);
    private final ThreadLocal<Boolean> betterLayerDisabled = ThreadLocal.withInitial(() -> false);
    public final LBGResourceReloader resourceReloader = new LBGResourceReloader();
    public final LBGDynamicTextureManager dynamicTextureManager = new LBGDynamicTextureManager();
    private String version;

    public void onInitializeClient(ModContainer mod) {
        this.version = mod.getVersionString();
        LambdaBetterGrass.log(LOGGER, "Initializing LambdaBetterGrass...");
        this.config.load();
        this.registerBuiltinResourcePacks(mod);
        LBGState.registerType("grass", LBGGrassState::new);
        LBGState.registerType("layer", LBGLayerState::new);
        ResourceLoader resourceLoader = ResourceLoader.get((class_3264)class_3264.field_14188);
        resourceLoader.registerReloader(LBGResourceReloader.ID, (class_3302)this.resourceReloader);
        resourceLoader.addReloaderOrdering(LBGResourceReloader.ID, ResourceReloaderKeys.Client.MODELS);
        resourceLoader.addReloaderOrdering(LBGResourceReloader.ID, ResourceReloaderKeys.Client.ATLAS);
        PreparableModelLoadingPlugin.register((sharedState, applyExecutor) -> ((LBGResourceReloader.LBGSharedState)sharedState.method_72362(LBGResourceReloader.SHARED_STATE_KEY)).awaitContext(), (lbgCtx, pluginCtx) -> pluginCtx.modifyBlockModelOnLoad().register(ModelModifier.WRAP_LAST_PHASE, (model, context) -> {
            class_1087.class_9979 newModel;
            LBGState state = lbgCtx.getState(context.state().method_26204());
            if (state != null && (newModel = state.getCustomUnbakedModel(context.state(), model)) != null) {
                return newModel;
            }
            return model;
        }));
    }

    public String getVersion() {
        return this.version;
    }

    private void registerBuiltinResourcePacks(ModContainer mod) {
        net.fabricmc.loader.api.ModContainer fabricMod = (net.fabricmc.loader.api.ModContainer)FabricLoader.getInstance().getModContainer(mod.id()).orElseThrow();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)LambdaBetterGrass.id("default"), (net.fabricmc.loader.api.ModContainer)fabricMod, (class_2561)class_2561.method_43469((String)"lambdabettergrass.resourcepack.default", (Object[])new Object[]{class_2561.method_43471((String)NAMESPACE)}), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)LambdaBetterGrass.id("x32"), (net.fabricmc.loader.api.ModContainer)fabricMod, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }

    public static void log(Logger logger, String msg) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambdaBetterGrass] " + (String)msg;
        }
        logger.info((String)msg);
    }

    public static void warn(Logger logger, String msg) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambdaBetterGrass] " + (String)msg;
        }
        logger.warn((String)msg);
    }

    public static void warn(Logger logger, String msg, Object ... args) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambdaBetterGrass] " + (String)msg;
        }
        logger.warn((String)msg, args);
    }

    public static void error(Logger logger, String msg, Object ... args) {
        if (!YumiMods.get().isDevelopmentEnvironment()) {
            msg = "[LambdaBetterGrass] " + (String)msg;
        }
        logger.error((String)msg, args);
    }

    public boolean hasBetterLayer() {
        if (this.config.hasBetterLayer()) {
            return this.betterLayerDisabled.get() == false;
        }
        return false;
    }

    public static class_2960 id(@NotNull String path) {
        return class_2960.method_60655((String)NAMESPACE, (String)path);
    }

    public static LambdaBetterGrass get() {
        return INSTANCE;
    }

    public static void pushDisableBetterLayer() {
        LambdaBetterGrass.get().betterLayerDisabled.set(true);
    }

    public static void popDisableBetterLayer() {
        LambdaBetterGrass.get().betterLayerDisabled.remove();
    }
}

