/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.model.LBGUnbakedModel;
import dev.lambdaurora.lambdabettergrass.resource.LBGContext;
import dev.lambdaurora.lambdabettergrass.util.VariantSelector;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBGGrassState
extends LBGState {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambdaBetterGrass|LBGGrassState");
    private final Map<class_2680, LBGMetadata> metadatas = new Object2ObjectOpenHashMap();

    public LBGGrassState(@NotNull class_2960 id, @NotNull class_3300 resourceManager, @NotNull JsonObject json, @NotNull class_2689<class_2248, class_2680> stateDefinition, @NotNull LBGContext context) {
        super(id, (class_2248)stateDefinition.method_11660());
        if (json.has("variants")) {
            record Entry(List<class_2769.class_4933<?>> properties, LBGMetadata metadata) {
            }
            List<Entry> variants = json.getAsJsonObject("variants").entrySet().stream().map(entry -> {
                JsonObject variant = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (variant.has("data")) {
                    class_2960 metadataId = class_2960.method_60654((String)variant.get("data").getAsString());
                    List<class_2769.class_4933<?>> properties = VariantSelector.extractProperties(stateDefinition, (String)entry.getKey());
                    return new Entry(properties, this.loadMetadata(resourceManager, context, metadataId));
                }
                return null;
            }).filter(Objects::nonNull).toList();
            for (class_2680 state2 : stateDefinition.method_11662()) {
                for (Entry variant : variants) {
                    assert (variant != null);
                    if (!VariantSelector.match(state2, variant.properties)) continue;
                    this.metadatas.put(state2, variant.metadata);
                }
            }
            if (stateDefinition.method_11659().contains(class_2741.field_12512)) {
                this.metadatas.forEach((state, metadata) -> {
                    class_2680 snowyState;
                    LBGMetadata snowyMetadata;
                    if (!((Boolean)state.method_11654((class_2769)class_2741.field_12512)).booleanValue() && (snowyMetadata = this.metadatas.get(snowyState = (class_2680)state.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)))) != null) {
                        snowyMetadata.snowyModelVariantProvider = bakedModel -> {
                            metadata.snowyModelVariant = bakedModel;
                        };
                    }
                });
            }
        } else if (json.has("data")) {
            class_2960 metadataId = class_2960.method_60654((String)json.get("data").getAsString());
            LBGMetadata metadata2 = this.loadMetadata(resourceManager, context, metadataId);
            for (class_2680 state3 : stateDefinition.method_11662()) {
                this.metadatas.put(state3, metadata2);
            }
        }
    }

    @Nullable
    private LBGMetadata loadMetadata(@NotNull class_3300 resourceManager, @NotNull LBGContext context, @NotNull class_2960 metadataId) {
        LBGMetadata lBGMetadata;
        class_2960 metadataResourceId = metadataId.method_48331(".json");
        InputStreamReader reader = new InputStreamReader(resourceManager.getResourceOrThrow(metadataResourceId).method_14482());
        try {
            JsonObject metadataJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            lBGMetadata = new LBGMetadata(resourceManager, context, metadataId, metadataJson);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LambdaBetterGrass.warn(LOGGER, "Could not load metadata `{}`.", metadataId, e);
                return null;
            }
        }
        reader.close();
        return lBGMetadata;
    }

    @Nullable
    public LBGMetadata getMetadata(@NotNull class_2680 state) {
        return this.metadatas.get(state);
    }

    @Override
    @Nullable
    public class_1087.class_9979 getCustomUnbakedModel(class_2680 state, class_1087.class_9979 originalModel) {
        LBGMetadata metadata = this.getMetadata(state);
        if (metadata != null) {
            return new LBGUnbakedModel(originalModel, metadata);
        }
        return null;
    }
}

