/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.resource.LBGContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class LBGState {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PATH_PREFIX = "bettergrass/states";
    private static final Object2ObjectMap<String, LBGStateProvider> LBG_STATES_TYPE = new Object2ObjectOpenHashMap();
    private final class_2960 id;
    private final class_2248 block;

    public LBGState(class_2960 id, class_2248 block) {
        this.id = id;
        this.block = block;
    }

    @NotNull
    public class_2960 id() {
        return this.id;
    }

    @NotNull
    public class_2248 block() {
        return this.block;
    }

    protected boolean matchVariant(String[] modelVariant, String[] dataVariant) {
        for (String dataProperty : dataVariant) {
            if (dataProperty.equals("*")) {
                return true;
            }
            boolean matched = false;
            for (String modelProperty : modelVariant) {
                if (!modelProperty.equals(dataProperty)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public abstract class_1087.class_9979 getCustomUnbakedModel(class_2680 var1, class_1087.class_9979 var2);

    public static void registerType(String type, LBGStateProvider stateProvider) {
        LBG_STATES_TYPE.put((Object)type, (Object)stateProvider);
    }

    public static Optional<LBGState> loadMetadataState(class_2960 id, class_3300 resourceManager, JsonObject json, class_2689<class_2248, class_2680> stateDefinition, LBGContext context) {
        String type = "grass";
        if (json.has("type")) {
            type = json.get("type").getAsString();
        }
        if (LBG_STATES_TYPE.containsKey((Object)type)) {
            return Optional.of(((LBGStateProvider)LBG_STATES_TYPE.get((Object)type)).create(id, resourceManager, json, stateDefinition, context));
        }
        LOGGER.warn("Could not find type {} for metadata state {}.", (Object)type, (Object)id);
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface LBGStateProvider {
        public LBGState create(class_2960 var1, class_3300 var2, JsonObject var3, class_2689<class_2248, class_2680> var4, LBGContext var5);
    }
}

