/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata.grass;

import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGGrassLayerTextures;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGLoadingGrassLayer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10813;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import net.minecraft.class_9826;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBGGrassLayer
implements class_10813 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambdaBetterGrass|LBGGrassLayer");
    private final LBGMetadata parentMetadata;
    public final int colorIndex;
    private final class_4730 connectTexture;
    private final class_4730 blendUpTexture;
    private final class_4730 blendUpMirroredTexture;
    private final class_4730 archTexture;
    private final Map<String, class_1058> bakedSprites = new Object2ObjectOpenHashMap();

    public LBGGrassLayer(class_3300 resourceManager, LBGMetadata metadata, List<LBGLoadingGrassLayer> layers) {
        this.parentMetadata = metadata;
        LBGLoadingGrassLayer first = layers.getFirst();
        this.colorIndex = first.colorIndex();
        List<LBGGrassLayerTextures> textures = layers.stream().map(layer -> LBGGrassLayerTextures.generate(resourceManager, metadata.id, layer)).toList();
        LBGGrassLayerTextures parentTextures = textures.getFirst();
        for (int i = 1; i < textures.size(); ++i) {
            LBGGrassLayerTextures texture = textures.get(i);
            LBGGrassLayerTextures oldTextures = parentTextures;
            parentTextures = parentTextures.merge(texture);
            oldTextures.close();
            texture.close();
        }
        this.connectTexture = new class_4730(class_1059.field_5275, parentTextures.resolveConnect());
        this.blendUpTexture = new class_4730(class_1059.field_5275, parentTextures.resolveBlendUp());
        this.blendUpMirroredTexture = new class_4730(class_1059.field_5275, parentTextures.resolveBlendUpMirrored());
        this.archTexture = new class_4730(class_1059.field_5275, parentTextures.resolveArch());
        this.parentMetadata.getTextures().add(this.connectTexture);
        this.parentMetadata.getTextures().add(this.blendUpTexture);
        this.parentMetadata.getTextures().add(this.blendUpMirroredTexture);
        this.parentMetadata.getTextures().add(this.archTexture);
    }

    @Nullable
    public class_1058 getBakedTexture(String name) {
        return this.bakedSprites.get(name);
    }

    public void bakeTextures(class_9826 textureGetter) {
        this.tryBakeSprite("connect", this.connectTexture, textureGetter);
        this.tryBakeSprite("blend_up", this.blendUpTexture, textureGetter);
        this.tryBakeSprite("blend_up_m", this.blendUpMirroredTexture, textureGetter);
        this.tryBakeSprite("arch", this.archTexture, textureGetter);
    }

    private void tryBakeSprite(String name, @Nullable class_4730 id, class_9826 textureGetter) {
        if (id == null) {
            id = new class_4730(class_1059.field_5275, class_1047.method_4539());
        }
        try {
            this.bakedSprites.put(name, textureGetter.method_65739(id, (class_10813)this));
        }
        catch (NullPointerException e) {
            LambdaBetterGrass.warn(LOGGER, "Could not bake sprite `{}` with id `{}`!", name, id);
            this.bakedSprites.put(name, textureGetter.method_65739(new class_4730(class_1059.field_5275, class_1047.method_4539()), (class_10813)this));
        }
    }

    public String toString() {
        return "LBGGrassLayer{id=" + String.valueOf(this.parentMetadata.id) + ", colorIndex=" + this.colorIndex + "}";
    }

    @NotNull
    public String debugName() {
        return "%s (Better Grass Layer %s)".formatted(this.parentMetadata.id, this.colorIndex);
    }
}

