/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata.grass;

import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGGrassMasks;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGLoadingGrassLayer;
import dev.lambdaurora.lambdabettergrass.util.LBGTextureGenerator;
import java.io.Closeable;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public record LBGGrassLayerTextures(@NotNull Texture connect, @NotNull Texture blendUp, @NotNull Texture blendUpMirrored, @NotNull Texture arch) implements Closeable
{
    public class_2960 resolveConnect() {
        return LBGGrassLayerTextures.resolveTexture(this.connect);
    }

    public class_2960 resolveBlendUp() {
        return LBGGrassLayerTextures.resolveTexture(this.blendUp);
    }

    public class_2960 resolveBlendUpMirrored() {
        return LBGGrassLayerTextures.resolveTexture(this.blendUpMirrored);
    }

    public class_2960 resolveArch() {
        return LBGGrassLayerTextures.resolveTexture(this.arch);
    }

    private static class_2960 resolveTexture(@NotNull Texture texture) {
        class_2960 id = texture.resolveId();
        if (texture instanceof DirectTexture) {
            DirectTexture directTexture = (DirectTexture)texture;
            LambdaBetterGrass.get().dynamicTextureManager.registerSprite(id, directTexture.image);
        }
        return id;
    }

    public LBGGrassLayerTextures merge(LBGGrassLayerTextures other) {
        class_1011 connectTexture = LBGTextureGenerator.applyMask(this.connect.getImage(), other.connect.getImage(), other.connect.getImage());
        class_1011 blendUpTexture = LBGTextureGenerator.applyMask(this.blendUp.getImage(), other.blendUp.getImage(), other.blendUp.getImage());
        class_1011 blendUpMirroredTexture = LBGTextureGenerator.applyMask(this.blendUpMirrored.getImage(), other.blendUpMirrored.getImage(), other.blendUpMirrored.getImage());
        class_1011 archTexture = LBGTextureGenerator.applyMask(this.arch.getImage(), other.arch.getImage(), other.arch.getImage());
        return new LBGGrassLayerTextures(new DirectTexture(this.connect.resolveId(), connectTexture), new DirectTexture(this.blendUp.resolveId(), blendUpTexture), new DirectTexture(this.blendUpMirrored.resolveId(), blendUpMirroredTexture), new DirectTexture(this.arch.resolveId(), archTexture));
    }

    @Override
    public void close() {
        this.connect.close();
        this.blendUp.close();
        this.blendUpMirrored.close();
        this.arch.close();
    }

    public static LBGGrassLayerTextures generate(class_3300 resourceManager, class_2960 metadataId, LBGLoadingGrassLayer layer) {
        LBGLoadingGrassLayer.Textures textures = layer.textures();
        LBGLoadingGrassLayer.Textures.Overrides overrides = textures.overrides();
        String[] path = metadataId.method_12832().split("/");
        Object name = path.length == 0 ? "undefined" : path[path.length - 1];
        if (layer.colorIndex() > -1) {
            name = (String)name + "_" + layer.colorIndex();
        }
        try (ResolutionContext context = new ResolutionContext(resourceManager, textures, layer.masks().withPngSuffix());){
            Texture connectTexture = LBGGrassLayerTextures.resolve(resourceManager, context, (String)name + "_connect", ResolutionContext::getConnectMaskTexture, overrides.connect());
            Texture blendUpTexture = LBGGrassLayerTextures.resolve(resourceManager, context, (String)name + "_blend_up", ResolutionContext::getBlendUpMaskTexture, overrides.blendUp());
            Texture blendUpMirroredTexture = LBGGrassLayerTextures.resolve(resourceManager, context, (String)name + "_blend_up_m", ResolutionContext::getBlendUpMirroredMaskTexture, overrides.blendUpMirrored());
            Texture archTexture = LBGGrassLayerTextures.resolve(resourceManager, context, (String)name + "_arch", ResolutionContext::getArchMaskTexture, overrides.arch());
            LBGGrassLayerTextures lBGGrassLayerTextures = new LBGGrassLayerTextures(connectTexture, blendUpTexture, blendUpMirroredTexture, archTexture);
            return lBGGrassLayerTextures;
        }
    }

    private static Texture resolve(class_3300 resourceManager, ResolutionContext context, String name, Function<ResolutionContext, class_1011> maskGetter, Optional<class_2960> override) {
        if (override.isPresent()) {
            return new FromDiskTexture(resourceManager, override.get());
        }
        class_2960 id = LambdaBetterGrass.id("block/bettergrass/" + name);
        class_1011 image = LBGTextureGenerator.applyMask(context.getSideTexture(), context.getTopTexture(), maskGetter.apply(context));
        return new DirectTexture(id, image);
    }

    private static class_2960 getTexturePath(class_2960 id) {
        return id.method_45134(path -> "textures/" + path + ".png");
    }

    public static sealed interface Texture
    extends Closeable
    permits DirectTexture, FromDiskTexture {
        public class_2960 resolveId();

        public class_1011 getImage();

        @Override
        public void close();
    }

    public record DirectTexture(class_2960 id, class_1011 image) implements Texture
    {
        @Override
        public class_2960 resolveId() {
            return this.id;
        }

        @Override
        public class_1011 getImage() {
            return this.image;
        }

        @Override
        public void close() {
        }
    }

    private static final class ResolutionContext
    implements AutoCloseable {
        private final class_3300 resourceManager;
        private final LBGLoadingGrassLayer.Textures textureIds;
        private final LBGGrassMasks masks;
        private class_1011 topTexture;
        private class_1011 sideTexture;
        private class_1011 connectMaskTexture;
        private class_1011 blendUpMaskTexture;
        private class_1011 blendUpMirroredMaskTexture;
        private class_1011 archMaskTexture;

        private ResolutionContext(class_3300 resourceManager, LBGLoadingGrassLayer.Textures textureIds, LBGGrassMasks masks) {
            this.resourceManager = resourceManager;
            this.textureIds = textureIds;
            this.masks = masks;
        }

        public class_1011 getTopTexture() {
            if (this.topTexture == null) {
                this.topTexture = LBGTextureGenerator.getNativeImage(this.resourceManager, LBGGrassLayerTextures.getTexturePath(this.textureIds.top()));
            }
            return this.topTexture;
        }

        public class_1011 getSideTexture() {
            if (this.sideTexture == null) {
                this.sideTexture = LBGTextureGenerator.getNativeImage(this.resourceManager, LBGGrassLayerTextures.getTexturePath(this.textureIds.side()));
            }
            return this.sideTexture;
        }

        public class_1011 getConnectMaskTexture() {
            if (this.connectMaskTexture == null) {
                this.connectMaskTexture = LBGTextureGenerator.getNativeImage(this.resourceManager, this.masks.connect());
            }
            return this.connectMaskTexture;
        }

        public class_1011 getBlendUpMaskTexture() {
            if (this.blendUpMaskTexture == null) {
                this.blendUpMaskTexture = LBGTextureGenerator.getNativeImage(this.resourceManager, this.masks.blendUp());
            }
            return this.blendUpMaskTexture;
        }

        public class_1011 getBlendUpMirroredMaskTexture() {
            if (this.blendUpMirroredMaskTexture == null) {
                this.blendUpMirroredMaskTexture = LBGTextureGenerator.mirrorImage(this.getBlendUpMaskTexture());
            }
            return this.blendUpMirroredMaskTexture;
        }

        public class_1011 getArchMaskTexture() {
            if (this.archMaskTexture == null) {
                this.archMaskTexture = LBGTextureGenerator.getNativeImage(this.resourceManager, this.masks.arch());
            }
            return this.archMaskTexture;
        }

        @Override
        public void close() {
            if (this.topTexture != null) {
                this.topTexture.close();
            }
            if (this.sideTexture != null) {
                this.sideTexture.close();
            }
            if (this.connectMaskTexture != null) {
                this.connectMaskTexture.close();
            }
            if (this.blendUpMaskTexture != null) {
                this.blendUpMaskTexture.close();
            }
            if (this.blendUpMirroredMaskTexture != null) {
                this.blendUpMirroredMaskTexture.close();
            }
            if (this.archMaskTexture != null) {
                this.archMaskTexture.close();
            }
        }
    }

    public static final class FromDiskTexture
    implements Texture {
        private final class_3300 resourceManager;
        private final class_2960 id;
        private class_1011 cached;

        public FromDiskTexture(class_3300 resourceManager, class_2960 id) {
            this.resourceManager = resourceManager;
            this.id = id;
        }

        @Override
        public class_2960 resolveId() {
            return this.id;
        }

        @Override
        public class_1011 getImage() {
            if (this.cached == null) {
                this.cached = LBGTextureGenerator.getNativeImage(this.resourceManager, LBGGrassLayerTextures.getTexturePath(this.id));
            }
            return this.cached;
        }

        @Override
        public void close() {
            this.cached.close();
            this.cached = null;
        }
    }
}

