/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata.layer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGCompiledLayerMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerType;
import dev.lambdaurora.lambdabettergrass.model.LBGLayerUnbakedModel;
import dev.lambdaurora.lambdabettergrass.resource.LBGContext;
import dev.lambdaurora.lambdabettergrass.util.VariantSelector;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LBGLayerState
extends LBGState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final JsonObject DEFAULT_METADATA_LAYER_JSON = new JsonObject();
    private final Map<class_2680, Map<LBGLayerType, LBGLayerMetadata>> metadatas = new Object2ObjectOpenHashMap();

    public LBGLayerState(class_2960 id, class_3300 resourceManager, JsonObject json, class_2689<class_2248, class_2680> stateDefinition, LBGContext context) {
        super(id, (class_2248)stateDefinition.method_11660());
        if (json.has("variants")) {
            JsonObject variants = json.getAsJsonObject("variants");
            variants.entrySet().forEach(entry -> {
                JsonObject variant = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (variant.has("data")) {
                    this.loadVariant((String)entry.getKey(), variant, resourceManager, stateDefinition, context);
                }
            });
        } else if (json.has("data")) {
            this.loadVariant("*", json, resourceManager, stateDefinition, context);
        } else {
            LOGGER.warn("Invalid state definition for {}, missing data or variants entry.", (Object)id);
        }
    }

    private void loadVariant(String variant, JsonObject json, class_3300 resourceManager, class_2689<class_2248, class_2680> stateDefinition, LBGContext context) {
        class_2960 metadataId = class_2960.method_12829((String)json.get("data").getAsString());
        class_2960 metadataResourceId = metadataId.method_48331(".json");
        context.layerTypeManager().forEach(type -> this.putOrReplaceMetadata(variant, metadataId, (LBGLayerType)type, DEFAULT_METADATA_LAYER_JSON, stateDefinition));
        List resources = resourceManager.method_14489(metadataResourceId);
        for (class_3298 resource : resources) {
            try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                JsonObject metadataJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (Map.Entry entry : metadataJson.entrySet()) {
                    Optional<LBGLayerType> type2 = context.layerTypeManager().get((String)entry.getKey());
                    if (type2.isEmpty() || !((JsonElement)entry.getValue()).isJsonObject()) continue;
                    this.putOrReplaceMetadata(variant, metadataId, type2.get(), ((JsonElement)entry.getValue()).getAsJsonObject(), stateDefinition);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Cannot load metadata file \"{}\" from layer state \"{}\" (variant: \"{}\").", new Object[]{metadataId, this.id(), variant, e});
            }
        }
    }

    private void putOrReplaceMetadata(String variant, class_2960 metadataId, LBGLayerType type, JsonObject metadataJson, class_2689<class_2248, class_2680> stateDefinition) {
        LBGLayerMetadata metadata = new LBGLayerMetadata(metadataId, type, metadataJson, stateDefinition);
        if (variant.equals("*")) {
            for (class_2680 state : stateDefinition.method_11662()) {
                this.putOrReplaceMetadata(state, metadata);
            }
        } else {
            List<class_2769.class_4933<?>> properties = VariantSelector.extractProperties(stateDefinition, variant);
            for (class_2680 state : stateDefinition.method_11662()) {
                if (!VariantSelector.match(state, properties)) continue;
                this.putOrReplaceMetadata(state, metadata);
            }
        }
    }

    private void putOrReplaceMetadata(class_2680 state, LBGLayerMetadata metadata) {
        Map metadatas = this.metadatas.computeIfAbsent(state, v -> new HashMap());
        metadatas.put(metadata.layerType(), metadata);
    }

    public Stream<LBGLayerMetadata> streamMetadata(class_2680 state) {
        return this.metadatas.entrySet().stream().filter(entry -> ((class_2680)entry.getKey()).equals((Object)state)).map(Map.Entry::getValue).flatMap(map -> map.values().stream());
    }

    @Override
    @Nullable
    public class_1087.class_9979 getCustomUnbakedModel(class_2680 state, class_1087.class_9979 originalModel) {
        List<LBGCompiledLayerMetadata> metadatas = this.streamMetadata(state).map(metadata -> {
            LBGLayerMetadata.LayerUnbakedModels models = metadata.getCustomUnbakedModel(state);
            return new LBGCompiledLayerMetadata(metadata.layerType(), metadata.hasLayerModel(), metadata.offset(), models);
        }).toList();
        if (!metadatas.isEmpty()) {
            return new LBGLayerUnbakedModel(originalModel, metadatas);
        }
        return null;
    }

    static {
        DEFAULT_METADATA_LAYER_JSON.addProperty("layer", Boolean.valueOf(true));
    }
}

