/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.model;

import dev.lambdaurora.lambdabettergrass.LBGMode;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.grass.LBGGrassLayer;
import dev.lambdaurora.lambdabettergrass.util.LayeredBlockUtils;
import it.unimi.dsi.fastutil.ints.Int2BooleanFunction;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.wrapper.WrapperBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class LBGBakedModel
extends WrapperBlockStateModel {
    private final LBGMetadata metadata;

    public LBGBakedModel(class_1087 baseModel, LBGMetadata metadata) {
        super(baseModel);
        this.metadata = metadata;
    }

    public void emitQuads(QuadEmitter quadEmitter, class_1920 world, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        class_2338 upPos;
        class_2680 up;
        LBGMode mode = LambdaBetterGrass.get().config.getMode();
        if (mode == LBGMode.OFF) {
            super.emitQuads(quadEmitter, world, pos, state, random, cullTest);
            return;
        }
        if (this.metadata.getSnowyModelVariant() != null && LambdaBetterGrass.get().hasBetterLayer() && state.method_28501().contains(class_2741.field_12512) && !((Boolean)state.method_11654((class_2769)class_2741.field_12512)).booleanValue() && !(up = world.method_8320(upPos = pos.method_10084())).method_26215() && LayeredBlockUtils.shouldGrassBeSnowy(world, pos, up, false, this.metadata.context())) {
            this.metadata.getSnowyModelVariant().emitQuads(quadEmitter, world, pos, (class_2680)state.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)), random, cullTest);
            return;
        }
        quadEmitter.pushTransform(quad -> {
            if (LBGBakedModel.canEditQuad((QuadView)quad)) {
                this.metadata.getLayer(quad.tintIndex()).ifPresent(layer -> {
                    boolean leftMatch;
                    if (mode == LBGMode.FASTEST) {
                        LBGBakedModel.spriteBake(quad, layer, "connect");
                        return;
                    }
                    class_2350 face = quad.nominalFace();
                    if (face == null) {
                        return;
                    }
                    class_2350 right = face.method_10170();
                    class_2350 left = face.method_10160();
                    if (this.canFullyConnect(world, state, pos, face) && LBGBakedModel.spriteBake(quad, layer, "connect")) {
                        return;
                    }
                    if (mode != LBGMode.FANCY) {
                        return;
                    }
                    boolean rightMatch = this.canConnect(world, state, pos.method_10074(), right) || this.canConnect(world, state, pos, right) && this.canFullyConnect(world, state, pos.method_10093(right), face);
                    boolean bl = leftMatch = this.canConnect(world, state, pos.method_10074(), left) || this.canConnect(world, state, pos, left) && this.canFullyConnect(world, state, pos.method_10093(left), face);
                    if (rightMatch && leftMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "arch");
                    } else if (rightMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "blend_up_m");
                    } else if (leftMatch) {
                        LBGBakedModel.spriteBake(quad, layer, "blend_up");
                    }
                });
            }
            return true;
        });
        super.emitQuads(quadEmitter, world, pos, state, random, cullTest);
        quadEmitter.popTransform();
    }

    private static boolean canEditQuad(QuadView quad) {
        class_2350 nominalFace = quad.nominalFace();
        if (nominalFace == null) {
            return false;
        }
        if (nominalFace.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        if (LBGBakedModel.testAll(i -> quad.y(i) > 1.0f || quad.y(i) < 0.0f)) {
            return false;
        }
        if (nominalFace.method_10166() == class_2350.class_2351.field_11048) {
            return !LBGBakedModel.testAll(i -> quad.z(i) != 0.0f) || !LBGBakedModel.testAll(i -> quad.z(i) != 1.0f);
        }
        if (nominalFace.method_10166() == class_2350.class_2351.field_11051) {
            return !LBGBakedModel.testAll(i -> quad.x(i) != 0.0f) || !LBGBakedModel.testAll(i -> quad.x(i) != 1.0f);
        }
        return true;
    }

    private static boolean testAll(Int2BooleanFunction tester) {
        for (int i = 0; i < 4; ++i) {
            if (tester.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean canFullyConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2350 direction) {
        return this.canConnect(world, self, selfPos, selfPos.method_10093(direction).method_10074());
    }

    private boolean canConnect(class_1920 world, class_2680 self, class_2338 start, class_2350 direction) {
        return this.canConnect(world, self, start, start.method_10093(direction));
    }

    private boolean canConnect(class_1920 world, class_2680 self, class_2338 selfPos, class_2338 adjacentPos) {
        boolean selfSnowy;
        class_2680 adjacent = world.method_8320(adjacentPos);
        class_2338 upPos = adjacentPos.method_10084();
        class_2680 up = world.method_8320(upPos);
        if (LambdaBetterGrass.get().hasBetterLayer() && self.method_26204() instanceof class_2493 && (selfSnowy = ((Boolean)self.method_11654((class_2769)class_2741.field_12512)).booleanValue()) && !up.method_26215()) {
            if (up.method_27852(class_2246.field_10477)) {
                return true;
            }
            if (adjacent.method_26204() instanceof class_2493 && LayeredBlockUtils.shouldGrassBeSnowy(world, upPos, up, true, this.metadata.context())) {
                return true;
            }
        }
        return LBGBakedModel.canConnect(self, adjacent) && (up.method_26215() || !up.method_26206((class_1922)world, upPos, class_2350.field_11033));
    }

    private static boolean canConnect(class_2680 self, class_2680 adjacent) {
        return self == adjacent;
    }

    private static boolean spriteBake(MutableQuadView quad, LBGGrassLayer layer, String texture) {
        class_1058 sprite = layer.getBakedTexture(texture);
        if (sprite != null) {
            quad.spriteBake(sprite, 4);
        }
        return sprite != null;
    }
}

