/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10594;
import net.minecraft.class_11582;
import net.minecraft.class_11583;
import net.minecraft.class_11586;
import net.minecraft.class_156;
import net.minecraft.class_2230;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2272;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2389;
import net.minecraft.class_2405;
import net.minecraft.class_2420;
import net.minecraft.class_2473;
import net.minecraft.class_2504;
import net.minecraft.class_2521;
import net.minecraft.class_2526;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3749;
import net.minecraft.class_4771;
import net.minecraft.class_5172;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import net.minecraft.class_5554;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import net.minecraft.class_8810;
import org.jetbrains.annotations.NotNull;

public class LBGDataGen
implements DataGeneratorEntrypoint {
    private static final class_2960 BARS_DATA = class_2960.method_60656((String)"bettergrass/data/bars");
    private static final class_2960 BED_DATA = class_2960.method_60656((String)"bettergrass/data/bed");
    private static final class_2960 BUTTON_DATA = class_2960.method_60656((String)"bettergrass/data/button");
    private static final class_2960 CAKE_DATA = class_2960.method_60656((String)"bettergrass/data/cake");
    private static final class_2960 CANDLE_DATA = class_2960.method_60656((String)"bettergrass/data/candle");
    private static final class_2960 CHAIN_DATA = class_2960.method_60656((String)"bettergrass/data/chain");
    private static final class_2960 COPPER_CHEST = class_2960.method_60656((String)"bettergrass/data/copper_chest");
    private static final class_2960 COPPER_GOLEM_STATUE = class_2960.method_60656((String)"bettergrass/data/copper_golem_statue");
    private static final class_2960 FLOWER_DATA = class_2960.method_60656((String)"bettergrass/data/flower");
    private static final class_2960 FLOWER_BED_DATA = class_2960.method_60656((String)"bettergrass/data/flower_bed");
    private static final class_2960 FLOWER_POT_DATA = class_2960.method_60656((String)"bettergrass/data/flower_pot");
    private static final class_2960 GLASS_PANE_DATA = class_2960.method_60656((String)"bettergrass/data/glass_pane");
    private static final class_2960 LANTERN_DATA = class_2960.method_60656((String)"bettergrass/data/lantern");
    private static final class_2960 LIGHTNING_ROD_DATA = class_2960.method_60656((String)"bettergrass/data/lightning_rod");
    private static final class_2960 TORCH_DATA = class_2960.method_60656((String)"bettergrass/data/torch");

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(LayerDataProvider::new);
    }

    static CompletableFuture<?> saveStable(class_7403 cachedOutput, JsonElement jsonElement, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha256(), (OutputStream)byteArrayOutputStream);
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("\t");
                    class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)jsonElement, (Comparator)class_2405.field_39213);
                }
                hashingOutputStream.write(10);
                cachedOutput.method_43346(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException e) {
                class_2405.field_40831.error("Failed to save file to {}", (Object)path, (Object)e);
            }
        }, (Executor)class_156.method_18349());
    }

    private static final class Context {
        private static final JsonObject EMPTY = new JsonObject();
        private final Map<class_2960, JsonElement> sources = new HashMap<class_2960, JsonElement>();

        private Context() {
        }

        public void addData(class_2960 id, JsonElement jsonElement) {
            this.sources.put(id.method_45138("data/"), jsonElement);
        }

        public void addEmptyLayerData(class_2960 id) {
            this.addData(id, (JsonElement)EMPTY);
        }

        public void addState(class_2960 id, JsonElement jsonElement) {
            this.sources.put(id.method_45138("states/"), jsonElement);
        }

        public void addSimpleLayerState(class_2960 id, class_2960 data) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "layer");
            json.addProperty("data", data.toString());
            this.addState(id, (JsonElement)json);
        }

        public void addLayerStateWithSimpleCondition(class_2960 id, String condition) {
            this.addLayerStateWithSimpleCondition(id, id.method_45138("bettergrass/data/"), condition);
        }

        public void addLayerStateWithSimpleCondition(class_2960 id, class_2960 dataId, String condition) {
            JsonObject state = new JsonObject();
            state.addProperty("type", "layer");
            JsonObject variants = new JsonObject();
            state.add("variants", (JsonElement)variants);
            JsonObject variant = new JsonObject();
            variants.add(condition, (JsonElement)variant);
            variant.addProperty("data", dataId.toString());
            this.addState(id, (JsonElement)state);
        }

        public void addWaterloggedSimpleLayerState(class_2960 id) {
            this.addLayerStateWithSimpleCondition(id, "waterlogged=false");
        }

        public void addWaterloggedSimpleLayerState(class_2960 id, class_2960 dataId) {
            this.addLayerStateWithSimpleCondition(id, dataId, "waterlogged=false");
        }
    }

    private static final class LayerDataProvider
    implements class_2405 {
        private final class_7784.class_7489 pathProvider;
        private final CompletableFuture<class_7225.class_7874> registryProvider;

        public LayerDataProvider(FabricDataOutput packOutput, CompletableFuture<class_7225.class_7874> registryProvider) {
            this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "bettergrass");
            this.registryProvider = registryProvider;
        }

        public String method_10321() {
            return "lambdabettergrass:layer_data_provider";
        }

        @NotNull
        public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
            return this.registryProvider.thenCompose(provider -> {
                Context context = new Context();
                provider.method_46762(class_7924.field_41254).method_42017().filter(class_6880::method_40227).forEach(entry -> {
                    class_2960 id = entry.method_40237().method_29177();
                    class_2248 block = (class_2248)entry.comp_349();
                    if (block instanceof class_2504) {
                        context.addWaterloggedSimpleLayerState(id, GLASS_PANE_DATA);
                    } else if (block instanceof class_2389 && !id.method_12832().contains("glass")) {
                        context.addWaterloggedSimpleLayerState(id, BARS_DATA);
                    } else if (block instanceof class_2244) {
                        context.addSimpleLayerState(id, BED_DATA);
                    } else if (block instanceof class_2269) {
                        context.addSimpleLayerState(id, BUTTON_DATA);
                    } else if (block instanceof class_2272 || block instanceof class_5545) {
                        context.addSimpleLayerState(id, CAKE_DATA);
                    } else if (block instanceof class_5544) {
                        context.addWaterloggedSimpleLayerState(id, CANDLE_DATA);
                    } else if (block instanceof class_5172) {
                        context.addWaterloggedSimpleLayerState(id, CHAIN_DATA);
                    } else if (block instanceof class_11582) {
                        context.addWaterloggedSimpleLayerState(id, COPPER_CHEST);
                    } else if (block instanceof class_11583) {
                        context.addWaterloggedSimpleLayerState(id, COPPER_GOLEM_STATUE);
                    } else if (block instanceof class_2356 || block instanceof class_2521) {
                        context.addSimpleLayerState(id, FLOWER_DATA);
                    } else if (block instanceof class_10594) {
                        context.addSimpleLayerState(id, FLOWER_BED_DATA);
                    } else if (block instanceof class_2362) {
                        context.addSimpleLayerState(id, FLOWER_POT_DATA);
                    } else if (block instanceof class_3749) {
                        context.addWaterloggedSimpleLayerState(id, LANTERN_DATA);
                    } else if (block instanceof class_5554) {
                        context.addWaterloggedSimpleLayerState(id, LIGHTNING_ROD_DATA);
                    } else if (block instanceof class_8810) {
                        context.addSimpleLayerState(id, TORCH_DATA);
                    } else if (block instanceof class_2323 || block instanceof class_2349 || block instanceof class_4771 || block instanceof class_2420 || block instanceof class_2473 || block instanceof class_2526) {
                        context.addEmptyLayerData(id);
                        context.addSimpleLayerState(id, id.method_45138("bettergrass/data/"));
                    } else if (block instanceof class_2533) {
                        context.addEmptyLayerData(id);
                        context.addLayerStateWithSimpleCondition(id, "half=top,waterlogged=false");
                    } else if (block instanceof class_2230 || block instanceof class_2281 || block instanceof class_2354 || block instanceof class_11586 || block instanceof class_2544) {
                        context.addEmptyLayerData(id);
                        context.addWaterloggedSimpleLayerState(id);
                    }
                });
                return CompletableFuture.allOf((CompletableFuture[])context.sources.entrySet().stream().map(entry -> LBGDataGen.saveStable(cachedOutput, (JsonElement)entry.getValue(), this.pathProvider.method_44107((class_2960)entry.getKey()))).toArray(CompletableFuture[]::new));
            });
        }
    }
}

