/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.resource.LBGContext;
import dev.lambdaurora.lambdabettergrass.resource.LBGLayerTypeManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class LBGResourceReloader
implements class_3302 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 ID = LambdaBetterGrass.id("resource_reloader");
    public static final class_3302.class_11559<LBGSharedState> SHARED_STATE_KEY = new class_3302.class_11559();

    public String method_22322() {
        return ID.toString();
    }

    public void prepareSharedState(class_3302.class_11558 sharedState) {
        LambdaBetterGrass.log(LambdaBetterGrass.LOGGER, "Reloading resources...");
        LambdaBetterGrass.get().dynamicTextureManager.reset();
        sharedState.method_72363(SHARED_STATE_KEY, (Object)new LBGSharedState());
    }

    public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor prepareExecutor, class_3302.class_4045 synchronizer, Executor applyExecutor) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LBGLayerTypeManager layerTypeManager = new LBGLayerTypeManager();
            layerTypeManager.load(sharedState.method_72361());
            return new LBGContext(layerTypeManager);
        }, prepareExecutor).thenCompose(context -> this.loadStates(sharedState.method_72361(), (LBGContext)context, prepareExecutor))).thenAcceptAsync(context -> {
            LBGSharedState lbgSharedState = (LBGSharedState)sharedState.method_72362(SHARED_STATE_KEY);
            lbgSharedState.contextFuture.complete((LBGContext)context);
            LambdaBetterGrass.get().dynamicTextureManager.finish();
        }, prepareExecutor)).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0));
    }

    private CompletableFuture<LBGContext> loadStates(class_3300 resourceManager, LBGContext context, Executor prepareExecutor) {
        List<CompletableFuture> futures = resourceManager.method_14488("bettergrass/states", id -> id.method_12832().endsWith(".json")).entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> this.loadState(resourceManager, context, (class_2960)entry.getKey(), (class_3298)entry.getValue()), prepareExecutor)).toList();
        return class_156.method_33791(futures).thenApplyAsync(states -> {
            states.stream().filter(Optional::isPresent).map(Optional::get).forEach(state -> context.states.put(state.block(), (LBGState)state));
            return context;
        }, prepareExecutor);
    }

    private Optional<LBGState> loadState(class_3300 resourceManager, LBGContext context, class_2960 id, class_3298 resource) {
        Optional<LBGState> optional;
        class_2960 stateId = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().substring("bettergrass/states".length() + 1, id.method_12832().length() - ".json".length()));
        Optional block = class_7923.field_41175.method_17966(stateId);
        if (block.isEmpty()) {
            return Optional.empty();
        }
        InputStreamReader reader = new InputStreamReader(resource.method_14482());
        try {
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            optional = LBGState.loadMetadataState(stateId, resourceManager, json, (class_2689<class_2248, class_2680>)((class_2248)block.get()).method_9595(), context);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load LambdaBetterGrass state {}.", (Object)stateId, (Object)e);
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static class LBGSharedState {
        private final CompletableFuture<LBGContext> contextFuture = new CompletableFuture();

        @NotNull
        public CompletableFuture<LBGContext> awaitContext() {
            return this.contextFuture;
        }
    }
}

