/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde;

import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.UnmodifiableConfig;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.DeserializerContext;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.SerdeException;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.TypeConstraint;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.serde.ValueDeserializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ConfigToPojoDeserializer
implements ValueDeserializer<UnmodifiableConfig, Object> {
    ConfigToPojoDeserializer() {
    }

    @Override
    public Object deserialize(UnmodifiableConfig value, Optional<TypeConstraint> resultType, DeserializerContext ctx) {
        Object instance;
        if (!resultType.isPresent()) {
            return value;
        }
        TypeConstraint t = resultType.get();
        Class<?> cls = t.getSatisfyingRawType().orElseThrow(() -> new SerdeException("Could not find a concrete type that can satisfy the constraint " + t));
        try {
            Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            instance = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new SerdeException("Failed to create an instance of " + cls, e);
        }
        ctx.deserializeFields(value, instance);
        return instance;
    }
}

