/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.api.config;

import ca.fxco.moreculling.api.config.ConfigOption;
import ca.fxco.moreculling.api.config.OptionOverride;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.ApiStatus;

public class ConfigAdditions {
    private static final Map<String, List<ConfigOption<?>>> additionOptions = new LinkedHashMap();
    private static final Map<String, OptionOverride> disabledOptions = new HashMap<String, OptionOverride>();
    private static final HashSet<String> separateGroupTabs = new HashSet();

    public static void addOption(String group, ConfigOption<?> option) {
        additionOptions.computeIfAbsent(group, g -> new LinkedList()).add(option);
    }

    public static void disableOption(String id, String reason, BooleanSupplier canChange) {
        disabledOptions.put(id, new OptionOverride(reason, canChange));
    }

    public static void useSeparateTab(String group) {
        separateGroupTabs.add(group);
    }

    public static void disableSeparateTab(String group) {
        separateGroupTabs.remove(group);
    }

    public static boolean isGroupSeparate(String group) {
        return separateGroupTabs.contains(group);
    }

    @ApiStatus.Internal
    public static Map<String, List<ConfigOption<?>>> getOptions() {
        return additionOptions;
    }

    @ApiStatus.Internal
    public static Map<String, OptionOverride> getDisabledOptions() {
        return disabledOptions;
    }
}

