/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.gui;

import dev.isxander.debugify.client.gui.BugFixController;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.error.DebugifyErrorHandler;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigGuiHelper {
    public static class_437 createConfigGui(DebugifyConfig config, class_437 parent) {
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"debugify.name")).save(config::save);
        LabelOption gameplayWarning = LabelOption.create((class_2561)class_2561.method_43471((String)"debugify.gameplay.warning").method_27692(class_124.field_1061));
        Option gameplayInMultiplayer = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"debugify.gameplay.enable_in_multiplayer")).binding((Object)false, () -> config.gameplayFixesInMultiplayer, value -> {
            config.gameplayFixesInMultiplayer = value;
        }).controller(TickBoxControllerBuilder::create).build();
        for (BugFix.Env env : BugFix.Env.values()) {
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)env.getDisplayName())).tooltip(new class_2561[]{class_2561.method_43471((String)env.getDescriptionKey())});
            for (FixCategory fixCategory : FixCategory.values()) {
                OptionGroup.Builder groupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)fixCategory.getDisplayName()));
                if (fixCategory == FixCategory.GAMEPLAY) {
                    groupBuilder.option((Option)gameplayWarning).option(gameplayInMultiplayer);
                }
                config.getBugFixes().forEach((bug, enabled) -> {
                    if (bug.env() == env && bug.category() == fixCategory) {
                        List<String> conflicts = bug.getActiveConflicts().stream().map(id -> ((ModContainer)FabricLoader.getInstance().getModContainer(id).orElseThrow()).getMetadata().getName()).toList();
                        boolean satisfiesOS = bug.satisfiesOSRequirement();
                        boolean errored = DebugifyErrorHandler.hasErrored(bug);
                        boolean unavailable = !conflicts.isEmpty() || !satisfiesOS || errored;
                        Option.Builder optionBuilder = Option.createBuilder().name((class_2561)class_2561.method_43470((String)bug.bugId())).binding((Object)bug.enabledByDefault(), () -> config.getBugFixes().get(bug), value -> config.getBugFixes().replace((BugFixData)bug, (Boolean)value)).customController(opt -> new BugFixController((Option<Boolean>)opt, errored)).available(!unavailable).flag(new OptionFlag[]{OptionFlag.GAME_RESTART});
                        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
                        if (errored) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43469((String)"debugify.error.mixin_error", (Object[])new Object[]{bug.bugId()}).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})});
                        }
                        for (String conflictMod : conflicts) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43469((String)"debugify.error.conflict", (Object[])new Object[]{bug.bugId(), conflictMod}).method_27692(class_124.field_1061)});
                        }
                        if (!satisfiesOS) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43469((String)"debugify.error.os", (Object[])new Object[]{bug.bugId(), class_2561.method_43471((String)bug.requiredOs().getDisplayName())}).method_27692(class_124.field_1061)});
                        }
                        if (bug.description() != null) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)bug.description())});
                        }
                        String fixExplanationTooltipKey = "debugify.fix_explanation." + bug.bugId().toLowerCase();
                        if (class_2477.method_10517().method_4678(fixExplanationTooltipKey)) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)fixExplanationTooltipKey).method_27692(class_124.field_1080)});
                        }
                        String fixEffectTooltipKey = "debugify.fix_effect." + bug.bugId().toLowerCase();
                        if (class_2477.method_10517().method_4678(fixEffectTooltipKey)) {
                            descriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)fixEffectTooltipKey).method_27692(class_124.field_1065)});
                        }
                        optionBuilder.description(descriptionBuilder.build());
                        groupBuilder.option(optionBuilder.build());
                    }
                });
                categoryBuilder.group(groupBuilder.build());
            }
            yacl.category(categoryBuilder.build());
        }
        yacl.category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"debugify.misc")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"debugify.misc.default_disabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"debugify.misc.default_disabled.description")})).binding((Object)false, () -> config.defaultDisabled, value -> {
            config.defaultDisabled = value;
        }).controller(BooleanControllerBuilder::create).build()).build());
        return yacl.build().generateScreen(parent);
    }
}

