/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8685;

public class PlayerVolumeEntry
extends VolumeEntry {
    @Nullable
    protected final PlayerState state;

    public PlayerVolumeEntry(@Nullable PlayerState state, AdjustVolumesScreen screen) {
        super(screen, new AdjustPlayerVolumeEntry(state != null ? state.getUuid() : class_156.field_25140, state != null ? state.getName() : null));
        this.state = state;
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }

    @Override
    public void renderElement(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        if (this.state != null) {
            class_8685 skin = GameProfileUtils.getSkin(this.state.getUuid());
            guiGraphics.method_25302(class_10799.field_56883, skin.comp_1626().comp_3627(), skinX, skinY, 8.0f, 8.0f, 24, 24, 8, 8, 64, 64);
            guiGraphics.method_25302(class_10799.field_56883, skin.comp_1626().comp_3627(), skinX, skinY, 40.0f, 8.0f, 24, 24, 8, 8, 64, 64);
            this.renderScrollingString(guiGraphics, (class_2561)class_2561.method_43470((String)this.state.getName()), PLAYER_NAME_COLOR);
        } else {
            guiGraphics.method_25302(class_10799.field_56883, OTHER_VOLUME_ICON, skinX, skinY, 16.0f, 16.0f, 24, 24, 16, 16, 16, 16);
            this.renderScrollingString(guiGraphics, OTHER_VOLUME, PLAYER_NAME_COLOR);
            if (hovered) {
                this.screen.postRender(() -> guiGraphics.method_51438(this.minecraft.field_1772, OTHER_VOLUME_DESCRIPTION, mouseX, mouseY));
            }
        }
    }

    public static class AdjustPlayerVolumeEntry
    implements AdjustVolumeSlider.AdjustVolumeEntry {
        private final UUID playerUUID;
        @Nullable
        private final String playerName;

        public AdjustPlayerVolumeEntry(UUID playerUUID, @Nullable String playerName) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
        }

        @Override
        public void save(double value) {
            VoicechatClient.PLAYER_VOLUME_CONFIG.setVolume(this.playerUUID, value, this.playerName == null ? "All other volumes" : String.format("Volume of %s", this.playerName));
            VoicechatClient.PLAYER_VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.PLAYER_VOLUME_CONFIG.getVolume(this.playerUUID);
        }

        @Override
        public double getAudioLevel() {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return -127.0;
            }
            return client.getTalkCache().getPlayerAudioLevel(this.playerUUID);
        }
    }
}

