/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4720;
import net.minecraft.class_4723;
import net.minecraft.class_630;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import traben.entity_model_features.EMF;
import traben.entity_model_features.EMFManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.IrisShadowPassDetection;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.models.parts.EMFModelPartVanilla;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class EMFModelPart
extends class_630 {
    public class_2960 textureOverride;
    protected long lastTextureOverride = -1L;
    public boolean isSetByAnimation = false;

    public EMFModelPart(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
        this.field_3663 = new ObjectArrayList(cuboids);
        this.field_3661 = new Object2ObjectOpenHashMap(children);
    }

    public void processArmItemOverrides(class_4587 matrices) {
        matrices.method_22903();
        this.method_22703(matrices);
        this.field_3661.values().forEach(v -> ((EMFModelPart)((Object)v)).processArmItemOverrides(matrices));
        matrices.method_22909();
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        try {
            EMFConfig.RenderModeChoice choice = ((EMFConfig)EMF.config().getConfig()).getRenderModeFor(EMFAnimationEntityContext.getEMFEntity());
            if (choice == EMFConfig.RenderModeChoice.NORMAL) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                return;
            }
            if (((EMFConfig)EMF.config().getConfig()).onlyDebugRenderOnHover && !EMFAnimationEntityContext.isClientHovered()) {
                this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                return;
            }
            switch (choice) {
                case GREEN: {
                    this.renderDebugTinted(matrices, vertices, light, overlay, k);
                    break;
                }
                case LINES: {
                    this.renderBoxes(matrices, class_310.method_1551().method_22940().method_23000().method_73477(this.lines()));
                    break;
                }
                case LINES_AND_TEXTURE: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                    this.renderBoxesNoChildren(matrices, class_310.method_1551().method_22940().method_23000().method_73477(this.lines()), 1.0f);
                    break;
                }
                case LINES_AND_TEXTURE_FLASH: {
                    this.renderWithTextureOverride(matrices, vertices, light, overlay, k);
                    float flash = (class_3532.method_15374((float)((float)System.currentTimeMillis() / 1000.0f)) + 1.0f) / 2.0f;
                    this.renderBoxesNoChildren(matrices, class_310.method_1551().method_22940().method_23000().method_73477(this.lines()), flash);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class_1921 lines() {
        return class_1921.method_23594();
    }

    private void renderDebugTinted(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        float flash = Math.abs(class_3532.method_15374((float)((float)System.currentTimeMillis() / 1000.0f)));
        int col = class_9848.method_61324((int)((int)(255.0f * flash)), (int)class_9848.method_61329((int)k), (int)((int)(255.0f * flash)), (int)class_9848.method_61320((int)k));
        this.renderWithTextureOverride(matrices, vertices, light, overlay, col);
    }

    void renderWithTextureOverride(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        if (this.textureOverride == null || this.lastTextureOverride == EMFManager.getInstance().entityRenderCount) {
            this.renderLikeETF(matrices, vertices, light, overlay, k);
        } else if (light != 0xF000F1 && !ETFRenderContext.isIsInSpecialRenderOverlayPhase()) {
            if (EMFAnimationEntityContext.getEMFEntity() != null && EMFAnimationEntityContext.getEMFEntity().etf$isBlockEntity() && ETF.IRIS_DETECTED && IrisShadowPassDetection.getInstance().inShadowPass()) {
                this.renderLikeETF(matrices, vertices, light, overlay, k);
                return;
            }
            if (vertices instanceof ETFVertexConsumer) {
                ETFVertexConsumer etfVertexConsumer = (ETFVertexConsumer)vertices;
                ETFTexture etfTextureTest = etfVertexConsumer.etf$getETFTexture();
                if (etfTextureTest != null && etfTextureTest.thisIdentifier.equals((Object)this.textureOverride)) {
                    this.renderLikeETF(matrices, vertices, light, overlay, k);
                    return;
                }
                class_1921 originalLayer = etfVertexConsumer.etf$getRenderLayer();
                if (originalLayer == null) {
                    return;
                }
                class_4597 provider = etfVertexConsumer.etf$getProvider();
                if (provider == null) {
                    return;
                }
                this.renderTextureOverrideWithoutReset(provider, matrices, light, overlay, k);
                provider.method_73477(originalLayer);
            } else {
                class_4597.class_4598 provider = class_310.method_1551().method_22940().method_23000();
                this.renderTextureOverrideWithoutReset((class_4597)provider, matrices, light, overlay, k);
            }
        }
    }

    private void renderTextureOverrideWithoutReset(class_4597 provider, class_4587 matrices, int light, int overlay, int k) {
        this.lastTextureOverride = EMFManager.getInstance().entityRenderCount;
        class_1921 layerModified = EMFAnimationEntityContext.getLayerFromRecentFactoryOrETFOverrideOrTranslucent(this.textureOverride);
        class_4588 newConsumer = provider.method_73477(layerModified);
        this.renderLikeVanilla(matrices, newConsumer, light, overlay, k);
        if (newConsumer instanceof ETFVertexConsumer) {
            ETFVertexConsumer newETFConsumer = (ETFVertexConsumer)newConsumer;
            ETFTexture etfTexture = newETFConsumer.etf$getETFTexture();
            if (etfTexture == null) {
                return;
            }
            ETFUtils2.RenderMethodForOverlay renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, k);
            ETFUtils2.renderEmissive((ETFTexture)etfTexture, (class_4597)provider, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
            ETFUtils2.renderEnchanted((ETFTexture)etfTexture, (class_4597)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay);
        }
    }

    void renderLikeVanilla(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                this.method_22702(matrices.method_23760(), vertices, light, overlay, k);
            }
            for (class_630 modelPart : this.field_3661.values()) {
                modelPart.method_22699(matrices, vertices, light, overlay, k);
            }
            matrices.method_22909();
        }
    }

    /*
     * Unable to fully structure code
     */
    private class_4588 testForBuildingException(class_4588 vertices) {
        block7: {
            block8: {
                block6: {
                    if (!(vertices instanceof class_287)) break block6;
                    testBuilding = (class_287)vertices;
                    break block7;
                }
                if (!(vertices instanceof class_4723)) break block8;
                sprite = (class_4723)vertices;
                if (!(sprite.field_21730 instanceof class_287)) break block8;
                testBuilding = (class_287)sprite.field_21730;
                break block7;
            }
            if (!(vertices instanceof class_4720.class_4589)) ** GOTO lbl-1000
            dub = (class_4720.class_4589)vertices;
            if (dub.field_21686 instanceof class_287) {
                testBuilding = (class_287)dub.field_21686;
            } else lbl-1000:
            // 2 sources

            {
                return vertices;
            }
        }
        if (testBuilding != null && !testBuilding.field_1556) {
            if (testBuilding instanceof ETFVertexConsumer && (etf = (ETFVertexConsumer)testBuilding).etf$getRenderLayer() != null && etf.etf$getProvider() != null) {
                allowed = ETFRenderContext.isAllowedToRenderLayerTextureModify();
                ETFRenderContext.preventRenderLayerTextureModify();
                vertices = etf.etf$getProvider().method_73477(etf.etf$getRenderLayer());
                if (allowed) {
                    ETFRenderContext.allowRenderLayerTextureModify();
                }
            } else {
                return null;
            }
        }
        return vertices;
    }

    void renderLikeETF(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        if ((vertices = this.testForBuildingException(vertices)) == null) {
            return;
        }
        ETFRenderContext.incrementCurrentModelPartDepth();
        this.renderLikeVanilla(matrices, vertices, light, overlay, k);
        if (ETFRenderContext.getCurrentModelPartDepth() != 1) {
            ETFRenderContext.decrementCurrentModelPartDepth();
        } else {
            ETFVertexConsumer etfVertexConsumer;
            ETFTexture texture;
            if (ETFRenderContext.isCurrentlyRenderingEntity() && vertices instanceof ETFVertexConsumer && (texture = (etfVertexConsumer = (ETFVertexConsumer)vertices).etf$getETFTexture()) != null && (texture.isEmissive() || texture.isEnchanted())) {
                ETFUtils2.RenderMethodForOverlay renderMethodForOverlay;
                class_4597 provider = etfVertexConsumer.etf$getProvider();
                class_1921 layer = etfVertexConsumer.etf$getRenderLayer();
                if (provider != null && layer != null && ETFUtils2.renderEmissive((ETFTexture)texture, (class_4597)provider, (ETFUtils2.RenderMethodForOverlay)(renderMethodForOverlay = (prov, ligh) -> this.renderLikeVanilla(matrices, prov, ligh, overlay, k))) | ETFUtils2.renderEnchanted((ETFTexture)texture, (class_4597)provider, (int)light, (ETFUtils2.RenderMethodForOverlay)renderMethodForOverlay)) {
                    provider.method_73477(layer);
                }
            }
            ETFRenderContext.resetCurrentModelPartDepth();
        }
    }

    public void renderBoxes(class_4587 matrices, class_4588 vertices) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                for (class_630.class_628 cuboid : this.field_3663) {
                    class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                    float[] col = this.debugBoxColor();
                    class_9974.method_62295((class_4587.class_4665)matrices.method_23760(), (class_4588)vertices, (class_238)box.method_1014(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)1.0f);
                }
            }
            for (class_630 modelPart : this.field_3661.values()) {
                if (!(modelPart instanceof EMFModelPart)) continue;
                EMFModelPart emf = (EMFModelPart)modelPart;
                emf.renderBoxes(matrices, vertices);
            }
            matrices.method_22909();
        }
    }

    protected abstract float[] debugBoxColor();

    public void renderBoxesNoChildren(class_4587 matrices, class_4588 vertices, float alpha) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty())) {
            matrices.method_22903();
            this.method_22703(matrices);
            if (!this.field_38456) {
                for (class_630.class_628 cuboid : this.field_3663) {
                    class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                    float[] col = this.debugBoxColor();
                    class_9974.method_62295((class_4587.class_4665)matrices.method_23760(), (class_4588)vertices, (class_238)box.method_1014(1.0E-4), (float)col[0], (float)col[1], (float)col[2], (float)alpha);
                }
            }
            matrices.method_22909();
        }
    }

    public void method_22702(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, int k) {
        try {
            for (class_630.class_628 cuboid : this.field_3663) {
                cuboid.method_32089(pose, vertexConsumer, i, j, k);
            }
        }
        catch (IllegalStateException e) {
            EMFUtils.logWarn("IllegalStateException caught in EMF model part");
        }
    }

    public String simplePrintChildren(int depth) {
        StringBuilder mapper = new StringBuilder();
        mapper.append("\n  | ");
        mapper.append("- ".repeat(Math.max(0, depth)));
        mapper.append(this.toStringShort());
        for (class_630 child : this.field_3661.values()) {
            if (!(child instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)child;
            mapper.append(emf.simplePrintChildren(depth + 1));
        }
        return mapper.toString();
    }

    public String toStringShort() {
        return this.toString();
    }

    public String toString() {
        return "generic emf part";
    }

    public class_630 getVanillaModelPartsOfCurrentState() {
        HashMap<String, class_630> children = new HashMap<String, class_630>();
        for (Map.Entry child : this.field_3661.entrySet()) {
            Object v = child.getValue();
            if (!(v instanceof EMFModelPart)) continue;
            EMFModelPart emf = (EMFModelPart)((Object)v);
            children.put((String)child.getKey(), emf.getVanillaModelPartsOfCurrentState());
        }
        List<class_630.class_628> finalCubes = this.field_3663.isEmpty() ? List.of(new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of())) : this.field_3663;
        class_630 part = new class_630((List)finalCubes, children);
        part.method_41918(this.method_41921());
        part.field_3654 = this.field_3654;
        part.field_3674 = this.field_3674;
        part.field_3675 = this.field_3675;
        part.field_3655 = this.field_3655;
        part.field_3656 = this.field_3656;
        part.field_3657 = this.field_3657;
        part.field_37938 = this.field_37938;
        part.field_37939 = this.field_37939;
        part.field_37940 = this.field_37940;
        return part;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPart> getAllChildPartsAsAnimationMap(String prefixableParents, int variantNum, Map<String, String> optifinePartNameMap) {
        Object object = this;
        if (object instanceof EMFModelPartRoot) {
            EMFModelPartRoot root = (EMFModelPartRoot)((Object)object);
            root.setVariantStateTo(variantNum);
        }
        Object2ReferenceOpenHashMap mapOfAll = new Object2ReferenceOpenHashMap();
        for (class_630 part : this.field_3661.values()) {
            if (!(part instanceof EMFModelPart)) continue;
            EMFModelPart emfPart = (EMFModelPart)part;
            String thisKey = "NULL_KEY_NAME";
            boolean addThis = false;
            if (part instanceof EMFModelPartCustom) {
                EMFModelPartCustom partCustom = (EMFModelPartCustom)part;
                thisKey = partCustom.id;
                addThis = true;
            } else if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla partVanilla = (EMFModelPartVanilla)part;
                thisKey = partVanilla.name;
                addThis = partVanilla.isOptiFinePartSpecified;
            }
            for (Map.Entry<String, String> entry : optifinePartNameMap.entrySet()) {
                if (!entry.getValue().equals(thisKey)) continue;
                thisKey = entry.getKey();
                break;
            }
            if (addThis) {
                mapOfAll.putIfAbsent((Object)thisKey, (Object)emfPart);
                if (prefixableParents.isBlank()) {
                    mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(thisKey, variantNum, optifinePartNameMap));
                    continue;
                }
                mapOfAll.putIfAbsent((Object)(prefixableParents + ":" + thisKey), (Object)emfPart);
                mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents + ":" + thisKey, variantNum, optifinePartNameMap));
                continue;
            }
            mapOfAll.putAll(emfPart.getAllChildPartsAsAnimationMap(prefixableParents, variantNum, optifinePartNameMap));
        }
        return mapOfAll;
    }

    public static class Animator
    implements Runnable {
        private Runnable animation = null;

        Animator() {
        }

        public boolean hasAnimation() {
            return this.animation != null;
        }

        public Runnable getAnimation() {
            return this.animation;
        }

        public void setAnimation(Runnable animation) {
            this.animation = animation;
        }

        @Override
        public void run() {
            if (this.animation != null) {
                this.animation.run();
            }
        }
    }
}

